#include "qdbt_tabular.h"
#include "qdbtsection.h"


void qdbt_tabular::_sectionClicked(int col)
{
	Object::emit("sectionClicked", 
		Py_BuildValue("(i)",col), 1
		);
};

void qdbt_tabular::_selected(int row,bool state)
{
	Object::emit("selected",
		Py_BuildValue("(ii)",row,(int)state), 1
		);
};

void qdbt_tabular::_activated(int row)
{
	Object::emit("activated",
		Py_BuildValue("(i)",row), 1
		);
};

void qdbt_tabular::_cellEdited(int row,int col)
{
	Object::emit("cellEdited",
		Py_BuildValue("(ii)",row,col), 1
		);
};

void qdbt_tabular::_cellSelected(int row,int col,bool state)
{
	Object::emit("cellSelected",
		Py_BuildValue("(iii)",row,col,(int)state), 1
		);

};

void qdbt_tabular::_cellActivated(int row,int col)
{
	Object::emit("cellActivated",
		Py_BuildValue("(ii)",row,col), 1
		);
};




qdbt_tabular::qdbt_tabular(Widget *parent, const char *name):
Widget("")
{
	if (parent)
		self = new QdbtTabular(parent->widget,name);
	else
		self = new QdbtTabular(widget,name);
		
	cCol = cRow = 0;
	cEditable = FALSE;
	cAlign = AlignLeft;

	QObject::connect(self,
		SIGNAL(sectionClicked(int)),
		this,
		SLOT(_sectionClicked(int)));

	QObject::connect(self,
		SIGNAL(activated(int)),
		this,
		SLOT(_activated(int)));

	QObject::connect(self,
		SIGNAL(selected(int,bool)),
		this,
		SLOT(_selected(int,bool)));

	QObject::connect(self,
		SIGNAL(cellEdited(int,int)),
		this,
		SLOT(_cellEdited(int,int)));

	QObject::connect(self,
		SIGNAL(cellSelected(int,int,bool)),
		this,
		SLOT(_cellSelected(int,int,bool)));

	QObject::connect(self,
		SIGNAL(cellActivated(int,int)),
		this,
		SLOT(_cellActivated(int,int)));

	setWidget( self );
};




qdbt_tabular::~qdbt_tabular()
{
	if (self)
		delete self;
	self = 0;
};

void qdbt_tabular::setDimensions(int r, int c)
{
	self->setDimensions(r,c);
};

void qdbt_tabular::setGeometry(int l,int t,int w,int h)
{
	self->setGeometry(l,t,w,h);
};

void qdbt_tabular::section(int col, char *text, int align)
{
  // change the heading of column 
//  QdbtSection *_section = self->section( col );

 QdbtSection *s = new QdbtSection( text, self );
  s->setAlignment( align );
  self->changeSection( s, col );

}

void qdbt_tabular::setColumnWidth(int col,int width)
{
	self->setColumnWidth(col,width);
}; 

void qdbt_tabular::insertRow(int row,bool selectable)
{
	self->insertRow(row,selectable);
};

void qdbt_tabular::removeRow(int row)
{
	self->removeRow(row);
};

void qdbt_tabular::insertCol(int col)
{
    	self->insertCol(col);
};

void qdbt_tabular::removeCol(int col)
{
	self->removeCol(col);
};

void qdbt_tabular::clear() 
{ setDimensions(0,0); }

int  qdbt_tabular::numRows() const
{
	return self->numRows();
};

int  qdbt_tabular::numCols() const
{
    return self->numCols();
};



QColor convert(const char *color)
{
	if (stricmp(color,"black")==0) return black;
	if (stricmp(color,"blue")==0) return blue;

	return black;
}


void qdbt_tabular::cellTextAndPixmap(const char *text,const char *pixmapPath,int row,int col,
                    const char *color,
                    int align,bool editable)
{
	QPixmap *p = new QPixmap( pixmapPath );
	QColor  c = convert(color);
		
	self->changeCell(text,p,row,col,c,align,editable);
};
		    
void qdbt_tabular::cellText(const char *text,int row,int col,
                    const char *color,
                    int align,bool editable)
{
	self->changeCell(text,row,col,
                    convert(color),
                    align,editable);
};
		    
void qdbt_tabular::cellPixmap(const char *pixmapPath,int row,int col,
                    int align)
{
	QPixmap *p = new QPixmap( pixmapPath );
	
	self->changeCell(p,row,col,align);
};

















