#ifndef MAINWINDOW_H
#define MAINWINDOW_H


#include <qmainwindow.h>
#include "Widget.h"
#include <qstatusbar.h>
#include "extWidget.h"

// foward declarations
class ToolBar;


extern int ToolBarOrientation(char *edge);



class mainwindow : public Widget
{
public:

	mainwindow(Widget *parent = 0, const char *name = 0, long flags = 0);
	virtual ~mainwindow();

	void setCentralWidget(Widget *);
	void addToolBar ( ToolBar *, const char * label, char *orientation = 0, bool newLine = FALSE );  	
	void removeToolBar ( ToolBar * ) ; 
	void show ();  

	void addStatusBar()
	{
		self->statusBar();
	};

	Widget *centralWidget()
	{
		Widget *w = new Widget( self->centralWidget() );
		return w;
	}
	
	void addWidgetToStatusBar(Widget *w, int i, bool b = FALSE )
	{
		self->statusBar()->addWidget((QWidget *) w->widget, i, b );
	};
	
	void removeWidgetFromStatusBar(Widget *w)
	{
		self->statusBar()->removeWidget((QWidget *) w->widget );
	};

private:
	pQMainWindow *self;
	Widget *client_area;
};



#endif



