#include "mainwindow.h"
#include "toolbar.h"
#include <qlabel.h>

int ToolBarOrientation(char *edge)
{
        QMainWindow::ToolBarDock dock;

	if (edge == 0) return QMainWindow::Top;
	     
	if (stricmp(edge,"Top")==0) 
		dock=QMainWindow::Top;
	else if (stricmp(edge,"Bottom")==0) 
		dock=QMainWindow::Bottom;	
	else if (stricmp(edge,"Right")==0) 
		dock=QMainWindow::Right;      
	else if (stricmp(edge,"Left")==0) 
		dock=QMainWindow::Left;
	else if (stricmp(edge,"TornOff")==0) 
		dock=QMainWindow::TornOff;	
	else 
		dock=QMainWindow::Unmanaged;
		
	return dock;	
};



/*
	Main Window constructor
 */
mainwindow::mainwindow(Widget *parent, const char *name, long flags):
Widget("")
{
	if (parent == 0)
		self = new pQMainWindow();
	else
		self = new pQMainWindow ( parent, name, flags );  
	self->setOwner( (Object *) this );
	setWidget( self );

	QWidget *c = new QWidget( self );
	self->setCentralWidget( c ); 
	self->setGeometry( c->x(), c->y(), self->width(), self->height());
	
//	QLabel *l = new QLabel("hello", self->centralWidget() );
};

mainwindow::~mainwindow()
{
//printf("Before ..\n");
        delete self->centralWidget();
	delete self;
//printf("After ..\n");
}


void mainwindow::setCentralWidget(Widget *w)
{
	self->setCentralWidget(w->widget);
};


void mainwindow::addToolBar ( ToolBar *tb, const char * label, 
		char *orientation, bool newLine ) 
{
        QMainWindow::ToolBarDock dock;

	dock = (QMainWindow::ToolBarDock) ToolBarOrientation(orientation);
	self->addToolBar( (QToolBar *) tb->widget, label, 
		dock, newLine );
};
 	
void mainwindow::removeToolBar ( ToolBar *tb ) 
{
	self->removeToolBar( (QToolBar *) tb->widget );
};
 
void mainwindow::show()
{
	self->show();
};  
