#ifndef EXTWIDGET_H
#define EXTWIDGET_H

#include "Object.h"
#include <qmainwindow.h>

/*
	Unfortunately in Qt you must overload some protected methods in the 
	thier widgets to trap resize events and keyboard events. To make
	matters worse moc does not support template classes.
	
	Hence I had to resort to cut and paste. I can not even use macros because moc
	gets called first.

	The best that I can do is put common methods in global functions 
	and move the owner pointer to public so I can pass the address.
	
	Oh well, if it works do it, right ? Nobody will see this from the python
	point of view.
*/

extern void sendResizeEvent(Object *owner, QResizeEvent *e);
extern void sendKeyPressEvent(Object *owner, QKeyEvent *e);

extern int ExitingApplication;

class pQMainWindow : public QMainWindow         
{                                         
Q_OBJECT                                  
public:
	pQMainWindow(QWidget *parent=0, const char *name=0, WFlags f = 0): 
	QMainWindow(parent,name,f) 
	{ 
		owner = 0; 
	} 

	void setOwner(Object *o) { owner = o; } 
	Object *owner; 

protected: 
	virtual void resizeEvent(QResizeEvent *e) 
	{ 
	if (ExitingApplication) return;

	if (owner) sendResizeEvent(owner, e); 
	QMainWindow::resizeEvent(e);
	}
	virtual void keyPressEvent ( QKeyEvent * e )  
	{
	if (ExitingApplication) return;

	if (owner) sendKeyPressEvent(owner, e);
	QMainWindow::keyPressEvent(e);
	}
};

class pQWidget : public QWidget
{                                         
Q_OBJECT                                  
public:
	pQWidget(QWidget *parent=0, const char *name=0, WFlags f = 0): 
	QWidget(parent,name,f) 
	{ 
		owner = 0; 
	} 
	void setOwner(Object *o) { owner = o; } 
	Object *owner; 
protected: 
	virtual void resizeEvent(QResizeEvent *e) 
	{ 
	if (owner) sendResizeEvent(owner, e); 
	QWidget::resizeEvent(e);
	}
	virtual void keyPressEvent ( QKeyEvent * e )  
	{
	if (owner) sendKeyPressEvent(owner, e);
	QWidget::keyPressEvent(e);
	}
};












#endif