#include "extWidget.h"

extern int InsideExecLoop;

void sendKeyPressEvent(Object *owner, QKeyEvent *e)
{
if (InsideExecLoop == 0) return;


PyObject *args = Py_BuildValue("(iii)",
	e->key(),
	e->ascii(),
	e->state());
owner->emit("keyPressEvent",args );
 Py_XDECREF(args);
}


void sendResizeEvent(Object *owner, QResizeEvent *e)
{
if (InsideExecLoop == 0) return;

QSize os, ns;

os = e->oldSize();
ns = e->size();

PyObject *args = Py_BuildValue("(ii)",
	ns.width() - os.width(),
	ns.height() - os.height());
owner->emit("resizeEvent", args);
Py_XDECREF(args);
}