/*  
	$Id: etreelist.h,v 1.2 1998/07/10 11:54:04 knuddel Exp $
	etreelist V0.9
	
	Requires the Qt widget libraries, available at no cost at 
    http://www.troll.no
       
    Copyright (C) 1998 Bernd Schumacher & Othmar Ehrhardt
                       B.Schumacher@eIT.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU Library General Public License as
	published by  
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
*/

#ifndef etreelist_h
#define etreelist_h

#include <qlistbox.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qlist.h>
#include <qstrlist.h>
#include <qkeycode.h>
#include <qregexp.h>
#include <qapp.h>


//extern QPixmap *NULLPixmap;


class ETreeListItem : public QListBoxItem
{
    private:
		friend class ETreeList;
        QPixmap pm;
//		QString itemPath;	//stores path (must be unique)
		bool parentItem;	//TRUE if Item is parent
		bool lastChild;		//TRUE if it is last item in branch
		bool chgIcon;		//FALSE if parent has its own icon
//		int level; 			//stores branchlevel		
		bool doExpand;

    public:
		QString itemPath;
		int level;	


 		virtual const QString getPath();
      	virtual void paint( QPainter * );
        virtual int height( const QListBox * ) const;
		virtual int height ( const QPainter * ) const;
        virtual int width( const QListBox * ) const;
        virtual const QPixmap *pixmap() { return &pm; };
//		virtual void setPixmap( QPixmap p ) { pm=p; };
		virtual QRect boundingRect( QPainter *p );
		virtual const char* getPathID(); // { return itemPath.data(); };
		virtual void setLastChild (bool doit){ lastChild=doit; };
		virtual bool isLastChild () { return lastChild; };
		virtual int getLevel() { return level; };
		virtual bool isExpanded() { return doExpand; }
		virtual void setExpand( bool doit ) { doExpand=doit; };
		virtual bool isParent() { return parentItem; };
		virtual bool changeIcon() { return chgIcon; };
			

        ETreeListItem( 	const char* path, const char *s, const QPixmap& p,
				 bool changeIcon, bool isParent, int lev, bool expand );
		virtual ~ETreeListItem();

		



};


class ETreeList : public QListBox
{
	Q_OBJECT

	public:
		ETreeList(	const char* rootText, QPixmap& rootIcon, 
					QPixmap& parentIcon, QPixmap& childIcon,
					QPixmap& parentOpenIcon, bool openFolders=FALSE,
					QWidget *parent=0, const char *name=0, WFlags f=0 );
		~ETreeList();

		void insertParent ( const char* path, const char* text,
				QPixmap& icon, bool expand=FALSE );
		void insertChild ( const char* path, const char* text, QPixmap& icon, bool expand=FALSE );
		void updateTree ( const char* path="/" );
		void removePath ( const char* path="/" );
		void setCurrentPath ( const char* path="/" );


		ETreeListItem *first() { allItems->first(); }
		ETreeListItem *next() { allItems->next(); }

//disable baseclass methods
	 void insertStrList ( const QStrList *, int ){};
     void insertStrList ( const char **, int, int ){}; 
     void insertItem ( const QListBoxItem *, int ){}; 
     void insertItem ( const char *, int ){};
     void insertItem ( const QPixmap &, int ){}; 
     void inSort ( const QListBoxItem * ){};
     void inSort ( const char *){};
     void removeItem ( int ){}; 
     void clear (){}; 
	 void changeItem ( const QListBoxItem *, int ){}; 
     void changeItem ( const char *, int ){};
     void changeItem ( const QPixmap &, int ){};
	 
	protected:
		void insertPath ( const char* pathID, const char* text, 
					QPixmap& icon, bool parent, bool expand, bool changeIcon );
		void paintCell ( QPainter *p, int row, int );
		void keyPressEvent( QKeyEvent *e );
		void mousePressEvent( QMouseEvent *e );
		const QString getParentID( const char* path );
		void drawBranch( QPainter *p, const char* path );
		bool hasChild( const char* path );
		int updateList( const char* path, int pos );
		bool showOpenFolder() { return doOpenFolder; };
		
	protected slots:
		void itemSelected ( int );
						
	private:
		QPixmap pIcon;
		QPixmap cIcon;
		QPixmap poIcon;	
		bool doOpenFolder;
		ETreeListItem *rootItem;
		QList <ETreeListItem> *allItems;
		QStrList *sortedItems;
		void insertItem( ETreeListItem* );

	signals:
		void selectedItem ( const char * );
		void highlightedItem ( const char * );
		void expandedItem ( const char * );
		void collapsedItem ( const char * );
		
		
};


#endif //etreelist_included
