#ifndef WIDGET
#define WIDGET

class Widget;
class PopupMenu;

#include <qmenubar.h>
#include "Object.h"
#include <qwidget.h>
#include "PopupMenu.h"
#include "extWidget.h"
#include <qtooltip.h>

class Widget : public Object
{
  Q_OBJECT;
public:
  enum FocusPolicy 
    { NoFocus = 0, TabFocus = 0x1, ClickFocus = 0x2, StrongFocus = 0x3 };

  Widget(char *abstractdummyvariable);
  Widget(Widget *parent=0, const char *name = 0, int has_splitter = 0);

  // for internal use
  Widget(QWidget *);
  	
  ~Widget();

  bool isTopLevel();
  bool isModal();
  bool isPopup();
  bool isDesktop();
  bool isEnabled();
  void setEnabled(int enable);
  const QRect& frameGeometry() const;
  const QRect& geometry() const;
  int x();
  int y();
  QPoint pos() const;
  QSize size() const;
  int width() const;
  int height() const;
  QRect rect() const;
  QRect childrenRect () const; 
  QSize minimumSize () const; 
  QSize maximumSize () const; 
  void setMinimumSize (const QSize&); 
  void setMinimumSize (int w, int h); 
  void setMaximumSize (const QSize&); 
  void setMaximumSize (int w, int h); 
  QSize sizeIncrement () const; 
  void setSizeIncrement (const QSize&); 
  void setSizeIncrement (int w, int h); 
  void setFixedSize (const QSize&); 
  void setFixedSize (int w, int h); 
  QPoint mapToGlobal (const QPoint&) const; 
  QPoint mapFromGlobal (const QPoint&) const; 
  QPoint mapToParent (const QPoint&) const; 
  QPoint mapFromParent (const QPoint&) const; 
  Widget* topLevelWidget () const; 
  const QColor& backgroundColor () const; 
  const QColor& foregroundColor () const; 
  virtual void setBackgroundColor (const QColor&); 
  const QPixmap* backgroundPixmap () const; 
  virtual void setBackgroundPixmap (const QPixmap&); 
  const QColorGroup& colorGroup () const; 
  const QPalette& palette () const; 
  virtual void setPalette (const QPalette&); 
  const QFont& font () const; 
  virtual void setFont (const QFont&); 
  QFontMetrics fontMetrics () const; 
  QFontInfo fontInfo () const; 
  const QCursor& cursor () const; 
  virtual void setCursor (const QCursor&); 
  const char* caption () const; 
  void setCaption (const char*); 
  const QPixmap* icon () const; 
  void setIcon (const QPixmap&); 
  const char* iconText () const; 
  void setIconText (const char*); 
  bool hasMouseTracking () const; 
  void setMouseTracking (int enable); 
  bool isActiveWindow () const; 
  void setActiveWindow (); 
  bool isFocusEnabled () const; 
  FocusPolicy focusPolicy () const; 
  void setFocusPolicy (FocusPolicy); 
  bool hasFocus () const; 
  void setFocus (); 
  void clearFocus (); 
  void grabMouse (); 
  void grabMouse (const QCursor&); 
  void releaseMouse (); 
  void grabKeyboard (); 
  void releaseKeyboard (); 
  bool isUpdatesEnabled () const; 
  void setUpdatesEnabled (int enable); 
  void update (); 
  void update (int x, int y, int w, int h); 
  void repaint (int erase=1); 
  void repaint (int x, int y, int w, int h, int erase=1); 
  void repaint (const QRect&, int erase=1); 
  virtual void show (); 
  virtual void hide (); 
  void iconify (); 
  virtual bool close (int forceKill=0); 
  bool isVisible () const; 
  void raise (); 
  void lower (); 
  virtual void move (int x, int y); 
  void move (const QPoint&); 
  virtual void resize (int w, int h); 
  void resize (const QSize&); 
  virtual void setGeometry (int x, int y, int w, int h); 
  void setGeometry (const QRect&); 
  virtual QSize sizeHint () const; 
  virtual void adjustSize (); 
  void recreate (Widget* parent, int, int xpos, int ypos, int
		 showIt=1); 
  void erase (); 
  void erase (int x, int y, int w, int h); 
  void erase (const QRect&); 
  void scroll (int dx, int dy); 
  void drawText (int x, int y, const char*); 
  void drawText (const QPoint&, const char*); 
  Widget* parentWidget () const; 

  void addPopupMenu(const char *label, PopupMenu *menu);
  void addSeparator();

  // adds a splitter to this widget.
  // If you choose this option you are only allowe to add two widgets
  // to this class as children. 	
  void addSplitter(int vertical, int opaque);  

  
  pQWidget *widget;

  void tooltip(const char *p)
  {
  	if (widget)
		QToolTip::add((QWidget *) widget, p);
  };

  
  
  
  

  // event handling....??? use signals/slots?? inefficient...callbacks?
public slots:
  void destroyed();


protected:
  virtual void setWidget(QWidget *widget);
  
private:
  QMenuBar *menu;  
  void create_menubar();

  
};



#endif
