#include "MainWindow.h"
#include "ToolBar.h"
#include "toolButton.h"

ToolBar::ToolBar( const char * label, MainWindow *p, char *edge,
     bool newLine, const char * name):Widget("")
	{
		QMainWindow::ToolBarDock dock;
	
		dock = (QMainWindow::ToolBarDock) ToolBarOrientation(edge);
		
		self = new QToolBar(label,
			(QMainWindow *) p->widget,
			dock,	
			newLine,
			name);
					
		Widget::setWidget(self);			
	};

void ToolBar::addToolButton(char *imagePath, char *caption, char *groupText, 
		PyObject *slot, char *toolTip, char *buttonName = 0)		
	{
		toolButton *tb;
		QPixmap pm(imagePath);
		
		if (buttonName == 0)
			buttonName = caption;
			
		tb = new toolButton( pm, caption, groupText, slot,  
			(QToolBar *) self, buttonName);
		QWhatsThis::add( tb->widget, toolTip, FALSE );			
	};	

