#include "RadioButton.h"

RadioButton::RadioButton(Widget *parent=0, const char *name=0)
{
  if(parent)
    radiobutton = new QRadioButton(parent->widget, name);
  else
    radiobutton = new QRadioButton(NULL, name);

  Button::setWidget((QButton*)radiobutton);
}

RadioButton::RadioButton(const char *text, Widget *parent, const char *name=0)
{
  if(parent)
    radiobutton = new QRadioButton(text, parent->widget, name);
  else
    radiobutton = new QRadioButton(text,NULL,name);

  Button::setWidget((QButton*)radiobutton);
}

bool RadioButton::isChecked() const
{
  return radiobutton->isChecked();
}

void RadioButton::setChecked(int check)
{
  radiobutton->setChecked(check);
}

QSize RadioButton::sizeHint() const
{
  return radiobutton->sizeHint();
}

