#ifndef POPUPMENU_H
#define POPUPMENU_H


#include <qpopmenu.h> 
#include "Object.h"
#include "Widget.h"
#include <Python.h>
#include <qpixmap.h> 


#define _TEXT   0x01
#define _PIXMAP 0x02
#define _POPUP  0x04


class PopupMenu : public QPopupMenu
{
 Q_OBJECT;		

public:
       PopupMenu ( Widget * parent=0, const char * name=0 );  
       ~PopupMenu ();

       void insert(	int opcode,
       			const char  *text, 
       			QPixmap      *pmap,
			PopupMenu   *submenu,
       			PyObject    *functor);

       void move(int x, int y);	
       int modal();
       void show();
	void hide();
	
       void popup(int left, int top, int indexAtPoint = 0);

public slots:
       void selected(int);

       
private:


       // maps an itemid to a functor	
       PyObject *dict;	       
       
};






#endif
