#include "PopupMenu.h"
#include <qpoint.h> 



void PopupMenu::move(int x, int y)
{
	QPopupMenu::move(x,y);
}

PopupMenu::PopupMenu( Widget * parent=0, const char * name=0 ):
QPopupMenu(parent, name)
{
	// create a new python dictionry.
	dict = PyDict_New();
	
	connect( this, 
		SIGNAL( activated(int) ), 
		this,
		SLOT( selected(int) ) 
		);
};
  
void PopupMenu::selected(int id)
{
	char key[16];
	PyObject *func;
	
	sprintf(key,"%d",id);
	func = PyDict_GetItemString(dict, key);
	PyEval_CallObject( func, PyTuple_New(0) );
};  
  
  
void PopupMenu::insert(int opcode,const char *text, 
	QPixmap *pmap, PopupMenu *submenu, PyObject *functor)
{
	int id, err;
	char key[32];

	switch(opcode)
	{
	case _TEXT: 
		id = insertItem(text);
		break;
	case _TEXT | _POPUP:
		id = insertItem(text, submenu);
		break;
	case _PIXMAP:
		id = insertItem(*pmap);
		break;
	case _PIXMAP | _POPUP:
		id = insertItem(*pmap, submenu);	
		break;
	case _TEXT | _PIXMAP:
		id = insertItem(*pmap,text);
		break;
	case _PIXMAP | _TEXT | _POPUP:
		id = insertItem(*pmap, text, submenu);
		break;			
	default:
		insertSeparator();
		return;	
	}
				
	// map id to functor
	sprintf(key,"%d",id);
	
	// assign functor to item
	PyDict_SetItemString(dict,key,functor);			
};
  
  
  
PopupMenu::~PopupMenu()
{
};
       
int PopupMenu::modal()
{
	return QPopupMenu::exec();
};

void PopupMenu::show()
{
	QPopupMenu::show();
};

void PopupMenu::hide()
{
	QPopupMenu::hide();
};

void PopupMenu::popup(int left, int top, int indexAtPoint)
{
	QPopupMenu::popup( QPoint(left,top), indexAtPoint );
};
