//
#include "Object.h"




Object::Object()
//  : QObject()
  : QWidget()
{
  
}

Object::~Object()
{
}


// create a timer
void Object::timerConnection(char *timername, int interval, PyObject *slot, PyObject *slotowner)
{
  // Python memory management
  Py_INCREF(slot);
   		
  TimerConn *c = new TimerConn;
  // get user name for timer
  c->timername = strdup(timername);	  
  // create a timer and cature the id
  c->id = startTimer( interval );
  c->slotowner = slotowner;
  c->slot = slot;
  
  timer_connections.append(c);
}

void Object::killTimer(char *timername)
{
  if (timername == 0)
  {
  	QObject::killTimers(); // kill all timers
	return;
  }
  	
  // try to match a timer to delete
  TimerConn *c;
  for(  c = timer_connections.first(); 
  	c !=0; 
	c = timer_connections.next()) 
  {
  	if (strcmp(c->timername,timername) == 0)
	{
		QObject::killTimer(c->id);
		return;
	}
  }  
	
}


// trap timer events
void Object::timerEvent(QTimerEvent *evt)
{
  int id = (int) evt->timerId();	

  // check timer connections
  TimerConn *c;
  for(  c = timer_connections.first(); 
  	c !=0; 
	c = timer_connections.next()) 
  {
        // match id
    	if (c->id == id) 
    	{
	  PyObject *args = Py_BuildValue("(i)", c->id);
	  PyEval_CallObject(c->slot, args);
	  return;  
    	}
  }  
}






void Object::connect(char *signal, PyObject *slot, PyObject *slotowner)
{
  
  // Python memory management
  Py_INCREF(slot);

  Connection *c = new Connection;
  c->signal = strdup(signal);
  c->slotowner = slotowner;
  c->slot = slot;
  connections.append(c);


//PyObject *list = PyList_New(0);
//PyList_Append( list, PyString_FromString("hello") );
//PyEval_CallObject(c->slot, list);
//PyObject_CallObject(slot, list);

//    printf("Connected signal %s to object at %p\n function ", signal, slotowner);
 //  PyObject_Print(slot, stdout, Py_PRINT_RAW);
 // printf("\n");
}

void Object::disconnect(PyObject *slot, char *signal)
{
  // Not yet implemented!
}

#ifdef emit
#undef emit
#endif

void Object::emit(char *signal, PyObject *args, int delArgs)
{
   // printf("Signal: %s   Args: ",signal);
   // PyObject_Print(args,stdout,Py_PRINT_RAW);
   // printf("\n");
  
  //if (args == NULL)
  //  args = Py_BuildValue("()");	

  Connection *c;
  for(c = connections.first(); c!=0; c = connections.next())
    {
      if(strcmp(c->signal, signal) == 0)
	{
	  if(c->slotowner)
	    {			// This should pass `self'!
	      PyEval_CallObject(c->slot, args);
	    }
	  else
	    {
	      PyEval_CallObject(c->slot, args);	      
	    }
	}
    }
	
  if (delArgs)
  {
    Py_XDECREF( args );
  }	
}

void Object::slotConnected(Object *from, char *signal, PyObject *slot)
{
}

void Object::slotDisconnect(Object *from, char *signal, PyObject *slot)
{
}

void Object::cleanup()
{
}
