#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <qmainwindow.h> 
#include "Widget.h"
#include <iostream.h>

class ToolBar;


inline int ToolBarOrientation(char *edge)
{
        QMainWindow::ToolBarDock dock;
	     
	if (stricmp(edge,"Top")==0) 
		dock=QMainWindow::Top;
	else if (stricmp(edge,"Bottom")==0) 
		dock=QMainWindow::Bottom;	
	else if (stricmp(edge,"Right")==0) 
		dock=QMainWindow::Right;      
	else if (stricmp(edge,"Left")==0) 
		dock=QMainWindow::Left;
	else if (stricmp(edge,"TornOff")==0) 
		dock=QMainWindow::TornOff;	
	else 
		dock=QMainWindow::Unmanaged;
		
	return dock;	
};

class pQMainWindow : public QMainWindow
{
Q_OBJECT
public:
	pQMainWindow( QWidget * parent=0, const char * name=0, WFlags f=0 ):
	QMainWindow(parent, name, f)
	{
//		cout << "pQWidget created\n";
		owner = 0;
	};
	
	void setOwner( Object *o )
	{
		owner = o;
	};
	
protected:

	virtual void resizeEvent ( QResizeEvent *e )
	{
		extern int InsideExecLoop;
		
		if (InsideExecLoop == 0) return;

		if (owner) { 
	
		  QSize s_old = e->oldSize();
		  QSize s_new = e->size();
		  double w, h;
		
		  w = s_new.width() - s_old.width();
		  h = s_new.height() - s_old.height();

//		  cout << "resizeEvent w = " << w << " h = " << h << endl;
				
		  owner->emit("resizeEvent", Py_BuildValue("(dd)",w,h));
		}
		
		QWidget::resizeEvent(e);
	};


private:
	Object *owner;	
}; 



class MainWindow : public Widget
{
private:
	pQMainWindow *self;	

public:
      MainWindow ( Widget * parent = 0, const char * name = 0, long f = 0 ):
      Widget("")
      {
      	self = new pQMainWindow(parent,name,f);
	self->setOwner( (Object *) this );	
	Widget::setWidget( self );
      };
      
       
      ~MainWindow () 
      {
      	delete self;
      };

/*      
      Widget* menuBar () const
      {
      	MenuBar *m = new MenuBar("");
	m->setWidget( self->menuBar() );
	return m;
      };
      
      Widget* statusBar () const
      {
	StatusBar *s = new StatusBar("");
	s->setWidget( self->statusBar() );
	return s;
      };
      
      
      QToolTipGroup* toolTipGroup () const
      virtual void setCentralWidget ( QWidget * ) 
      QWidget* centralWidget () const      
      void setDockEnabled ( ToolBarDock dock, bool enable ) 
      bool isDockEnabled ( ToolBarDock dock ) const
*/      
      void addToolBar ( Widget *tb, const char * label, /*ToolBarDock*/ char
	      *edge = "Top", bool nl = FALSE )
      {	
        QMainWindow::ToolBarDock dock;
	
	dock = (QMainWindow::ToolBarDock) ToolBarOrientation(edge);
	//cout <<  ((unsigned long)tb->widget) <<  label <<  dock <<  nl << endl;
      	self->addToolBar( (QToolBar *) tb->widget, label, dock, nl); 
      };
      
      void removeToolBar ( Widget *tb ) 
      {
      	self->removeToolBar( (QToolBar *) tb->widget );
      };
      
      virtual void show () 
      {
      	self->show();
      };
      
      bool rightJustification () const
      {
      	return self->rightJustification();
      };
      
      bool usesBigPixmaps () const
      {
        return self->usesBigPixmaps();
      };
      
      
//      virtual bool eventFilter ( QObject *, QEvent * ) 
};



#include "ToolBar.h"


#endif
