#ifndef LISTVIEW_H
#define LISTVIEW_H

#include <qlistview.h>
#include "Widget.h"






class ListView : public Widget
{
private:
	QListView *self;
public:
    ListView( Widget * parent = 0, const char * name = 0 ):
    Widget(parent,name)
    {
    	if (parent)
    		self = new QListView( parent->widget, name );
    	else
    		self = new QListView( parent, name );		
    };
    
    ~ListView()
    {
    	if (self)
    		delete self;
    	self = 0;
    };
   
    int treeStepSize() const
    {
    	self->treeStepSize();
    };
    
    void setTreeStepSize( int s )
    {
    	self->setTreeStepSize( s );
    };

     void insertItem( ListViewItem *p )
     {
     	self->insertItem( p );
     };
     
     void clear()
     {
     	self->clear();
     };

    // QHeader * header() const;

     int addColumn( const char * label, int size = -1)
     {
     	return self->addColumn(  label, size);
     };
     
     void setColumnText( int column, const char * label )
     {
     	self->setColumnText( column, label );
     };
     
    const char* columnText( int column ) const
    {
    	return self->columnText( column );
    };
    
     void setColumnWidth( int column, int width )
     {
     	self->setColumnWidth( column, width );
     };
     
    int columnWidth( int column ) const
    {
    	return self->columnWidth( column );
    };
   

};


#endif