class QFont
{
public:
  enum StyleHint { Helvetica, Times, Courier, OldEnglish,  System, AnyStyle,
		   SansSerif  = Helvetica,
		   Serif      = Times,
		   TypeWriter = Courier,
		   Decorative = OldEnglish};
  enum Weight    { Light = 25, Normal = 50, DemiBold = 63,
		   Bold  = 75, Black  = 87 };
  enum CharSet   { Latin1, ISO_8859_1 = Latin1, AnyCharSet };
  
  %name(QFont) QFont();
  /* Default font */
  %name(QFontV) QFont(const char *family, int pointSize=12, int weight=Normal,
		     bool italic=FALSE);
  /* Font with settings */
  %name(QFontCopy) QFont(const QFont&);
  // skip operator

  const char *family()        const;
  void        setFamily( const char * );
  int         pointSize()     const;
  void        setPointSize( int );
  int         weight()        const;
  void        setWeight( int );
  bool        bold()          const;
  void        setBold( bool );
  bool        italic()        const;
  void        setItalic( bool );
  bool        underline()     const;
  void        setUnderline( bool );
  bool        strikeOut()     const;
  void        setStrikeOut( bool );
  bool        fixedPitch()    const;
  void        setFixedPitch( bool );
  StyleHint   styleHint()     const;
  void        setStyleHint( StyleHint );
  CharSet     charSet()       const;
  void        setCharSet( CharSet );
  bool        rawMode()       const;
  void        setRawMode( bool );
  
  bool        exactMatch()    const;
  
  //  bool        operator==( const QFont & ) const;
  //bool        operator!=( const QFont & ) const;

  //QString     key() const;

  static const QFont &defaultFont();
  static void setDefaultFont( const QFont & );

  static const char  *substitute( const char *familyName );
  static void insertSubstitution( const char *, const char * );
  static void removeSubstitution( const char * );
  //   static void listSubstitutions( QStrList * );
};
