#ifndef FILEDIALOG_H
#define FILEDIALOG_H

#include <qfiledlg.h>
#include "Object.h"
#include "Widget.h"


extern const char *getOpenFileName ( const char * initially = 0, const char * filter= 0,
                 Widget * parent = 0, const char * name = 0 ); 
                       
extern const char *getSaveFileName ( const char * initially = 0, const char * filter= 0,
                 Widget * parent = 0, const char * name = 0 ); 
                                              
extern const char *getExistingDirectory ( const char * dir = 0, Widget * parent = 0,
                 const char * name = 0 ); 


class FileDialog : public Object
{
Q_OBJECT;
	
public:
				
	FileDialog();
	virtual ~FileDialog();
	
	int left();
	int top();
	int width();
	int height();
	
	void show();
	
	void create(const char *dirName, const char *filter=0,
		QWidget *parent=0, const char *name=0, bool
		modal=FALSE);
	
	void create(QWidget *parent=0, const char *name=0,
		bool modal=FALSE);

	const char *path();
	const char *selectedFile();
			
public slots:
	void fileHighlighted(const char *);
	void fileSelected(const char *);
	void dirEntered(const char *);
				
		
				
private:
	QFileDialog *f;
	QString filename;
	
	void setup();
	
	
};



// convieniant modal file dialog, returns the path selected
extern const char *ModalFileDialog(
	const char *dirName = 0,
	const char *filter  = 0,
	QWidget *parent     = 0,
	const char *name    = 0
	);
	
	



#endif
