#include "Dialog.h"



Dialog::Dialog(Widget *parent=0, const char *name=0, int modal=0)
{
  if(parent)
    setWidget(new QDialog(parent->widget, name, modal));
  else
    setWidget(new QDialog(NULL, name, modal));
}

Dialog::~Dialog()
{
}

void Dialog::setWidget(QDialog *_dialog)
{
  dialog = _dialog;
  Widget::setWidget((QWidget*)dialog);
}

int Dialog::exec()
{
  return dialog->exec();
}

int Dialog::result() const
{
  return dialog->result();
}

void Dialog::show()
{
  dialog->show();
}

void Dialog::move(int x, int y)
{
  dialog->move(x,y);
}

void Dialog::move(const QPoint& point)
{
  dialog->move(point);
}

void Dialog::resize(int w, int h)
{
  dialog->resize(w,h);
}

void Dialog::resize(const QSize& s)
{
  dialog->resize(s);
}

void Dialog::setGeometry(int x, int y, int w, int h)
{
  dialog->setGeometry(x,y,w,h);
}

void Dialog::setGeometry(const QRect &r)
{
  dialog->setGeometry(r);
}






