#include <qcombo.h>
#include "Widget.h"

class ComboBox : public Widget
{
  Q_OBJECT;
public:
  ComboBox(int rw, Widget *parent=0, const char *name=0);
  ComboBox(Widget *parent=0, const char *name=0);
  ~ComboBox();

  int count() const;
  
  void insertList(PyObject *list);
  // allows a list of text/pixmaps to be inserted
  
  void insertItem( const char *text, int index=-1 );
  void insertItem( const QPixmap &pixmap, int index=-1 );
  
  void removeItem( int index );
  void clear();
  
  const char *currentText() const;
  const char *text( int index ) const;
  const QPixmap *pixmap( int index ) const;
  
  void changeItem( const char *text, int index );
  void changeItem( const QPixmap &pixmap, int index );
  
  int currentItem() const;
  void setCurrentItem( int index );
  
  bool autoResize()    const;
  void setAutoResize( bool );
  QSize sizeHint() const;
  
  void setBackgroundColor( const QColor & );
  void setPalette( const QPalette & );
  void setFont( const QFont & );
  void setEnabled( int );
  
  void setSizeLimit( int );
  int sizeLimit() const;
  
  void setMaxCount( int );
  int maxCount() const;
  
  enum Policy { NoInsertion, AtTop, AtCurrent, AtBottom,
		AfterCurrent, BeforeCurrent };
  
  void setInsertionPolicy( ComboBox::Policy policy );

	void InsertionPolicy(const char *); 
	
  ComboBox::Policy insertionPolicy() const;
  
public slots:
  //signals:
  void activated( int index );
  void highlighted( int index );
  void activated( const char * );
  void highlighted( const char * );

public:

  virtual void setWidget(QComboBox *combobox);

  QComboBox *combobox;

};

