class QColor
{
public:
  %name(QColor) QColor();
  %name(QColorRGB) QColor(int r, int g, int b);
  // skip
  %name(QColorName) QColor(const char *name);
  %name(QColorCopy) QColor(const QColor&);
  // skip
  bool isValid();
  bool isDirty();
  void setNamedColor(const char *name);
  void rgb(int *r, int *g, int *b);
  // skip
  void setRgb(int r, int g, int b);
  // skip
  int red();
  int green();
  int blue();
  void hsv(int *h, int *s, int *v);
  void setHsv(int h, int s, int v);
  QColor light(int f = 112);
  QColor dark(int f = 220);
  // skip operators
  uint alloc();
  uint pixel();

  static bool lazyAlloc();
  static void setLazyAlloc(int);
  static int maxColors();
  static int numBitPlanes();
  static int enterAllocContext();
  static void leaveAllocContext();
  static int currentAllocContext();
  static void destroyAllocContext(int);
};

