#include <Python.h>
#include <qbutton.h>
#include "Button.h"

Button::Button(Widget *parent, const char *name)
  : Widget("")			// abstract widget constructor
{
}

Button::~Button()
{
}

void Button::setWidget(QButton *_button)
{
  button = _button;
  QObject::connect(button,SIGNAL(pressed()),this,SLOT(pressed()));
  QObject::connect(button,SIGNAL(released()),this,SLOT(released()));
  QObject::connect(button,SIGNAL(clicked()),this,SLOT(clicked()));
  QObject::connect(button,SIGNAL(toggled(bool)),this,SLOT(toggled(bool)));
  Widget::setWidget((QWidget*)button);
}

const char *Button::text()
{
  return button->text();
}

void Button::setText(const char *text)
{
  button->setText(text);
}

const QPixmap* Button::pixmap() const
{
  return button->pixmap();
}

void Button::setPixmap(const QPixmap& pixmap)
{
  button->setPixmap(pixmap);
}

bool Button::isToggleButton()
{
  return button->isToggleButton();
}

bool Button::isDown()
{
  return button->isDown();
}

bool Button::isOn()
{
  return button->isOn();
}

bool Button::autoResize()
{
  return button->autoResize();
}

void Button::setAutoResize(bool ar)
{
  button->setAutoResize(ar);
}

void Button::setAutoRepeat(bool ar)
{
  button->setAutoRepeat(ar);
}

bool Button::autoRepeat()
{
  return button->autoRepeat();
}

void Button::setDown(bool enable)
{
 button->setDown(enable);
}

void Button::pressed()
{
  emit("pressed", NULL);
}

void Button::released()
{
  emit("released", NULL);
}

void Button::clicked()
{
  emit("clicked", NULL);
}

void Button::toggled(bool toggled)
{
  PyObject *args;
  args = Py_BuildValue("(i)",toggled);
  emit("toggled",args);
  Py_XDECREF(args);
}
