#ifndef BOXLAYOUT_H
#define BOXLAYOUT_H

#include "Layout.h"
#include <qlayout.h>

class BoxLayout : public Layout
{
  Q_OBJECT;
public:
  enum Direction { LeftToRight, RightToLeft, TopToBottom, BottomToTop, 
		   Down = TopToBottom, Up = BottomToTop };
    
  BoxLayout(Widget *parent, Direction d, int border=0, 
	    int autoBorder=-1, const char *name=0);
  
  BoxLayout(Direction d, int autoBorder=-1,
	    const char* name=0);
  
  ~BoxLayout();
  
  void addWidget(Widget *w, int stetch=0, int alignment = AlignCenter);
  void addSpacing(int size);
  void addStretch(int stretch=0);
  void addLayout(Layout *layout, int stretch=0);
  Direction direction() const;
  void addStrut(int strut);
  
  virtual void setLayout(QBoxLayout *bl);
  QBoxLayout *boxlayout;
};
      
#endif
