#include "BoxLayout.h"


BoxLayout::BoxLayout(Widget *parent, Direction d, int border=0, 
	  int autoBorder=-1, const char *name=0)
{
  if(parent)
    boxlayout = new QBoxLayout(parent->widget, (QBoxLayout::Direction)d, 
			       border, autoBorder, name);
  else
    boxlayout = new QBoxLayout(NULL, (QBoxLayout::Direction)d, 
			       border, autoBorder, name);

  setLayout(boxlayout);
}
    
BoxLayout::BoxLayout(Direction d, int autoBorder=-1,
	  const char* name=0)
{
  boxlayout = new QBoxLayout((QBoxLayout::Direction)d,autoBorder,name);
  setLayout(boxlayout);
}
    
BoxLayout::~BoxLayout()
{
  delete boxlayout;
}

void BoxLayout::addWidget(Widget *w, int stretch=0, 
			  int alignment )
{
  if(w)
    boxlayout->addWidget(w->widget, stretch, alignment);
}

void BoxLayout::addSpacing(int size)
{
  boxlayout->addSpacing(size);
}

void BoxLayout::addStretch(int stretch=0)
{
  boxlayout->addStretch(stretch);
}

void BoxLayout::addLayout(Layout *layout, int stretch=0)
{
  boxlayout->addLayout(layout->layout, stretch);
}

BoxLayout::Direction BoxLayout::direction() const
{
  return (BoxLayout::Direction)boxlayout->direction();
}

void BoxLayout::addStrut(int strut)
{
  boxlayout->addStrut(strut);
}

void BoxLayout::setLayout(QBoxLayout *bl)
{
  boxlayout = bl;
  Layout::setLayout((QLayout*)bl);
}
      
