#ifndef APPLICATION
#define APPLICATION

#include <qapp.h>
#include "Widget.h"
#include "Object.h"


extern QList<Widget> *Widgets;

class Application : public Object
{
  Q_OBJECT;
public:
  Application();
  ~Application();

  int argc();
  char **argv();

  Widget *mainWidget();
  void setMainWidget(Widget *);
  Widget *focusWidget();
  int exec();
  void processEvents();
  int enter_loop();
  void exit_loop();
  void setOverrideCursor ( const QCursor *cursor,
             bool replace=FALSE )
  {
	a->setOverrideCursor( *cursor, replace );
  };
  
  void restoreOverrideCursor()
  {
  	a->restoreOverrideCursor(); 
  };            
  

public slots:
  void quit();			/* use this as a slot */
  void lastWindowClosed();	/* this is a signal */

private:
  QApplication * a;
};

extern Application *App;


#endif
