#include "Widget.h"
#include "Application.h"
#include <qlist.h>
#include <qwidget.h>
#include <signal.h>

int  ExitingApplication=0;
int  InsideExecLoop=0;
int 	     refcnt=0;
char *QtArgv = "Python/Qt";

// the one and only QApplication object
int ONE=1;
QApplication TheApp(ONE, &QtArgv);


#include <qpixmap.h>

void ignore(int x) {
  exit(0);	
}



Application::Application()
{
a = &TheApp;
  if (refcnt == 0)
  {
  	int args=1;
	
	QPixmap *NULLPixmap = new QPixmap;
  }
  refcnt++;  		

   // we are going down anyway 
   signal( SIGSEGV, ignore );
   signal( SIGILL, ignore );	



  if(!Widgets)
    {
      // printf("Creating widget list!\n");
      Widgets = new QList<Widget>;
    }

   QObject::connect(a, 
	SIGNAL(lastWindowClosed()), 
	this, 
	SLOT(lastWindowClosed()));
}

Application::~Application()
{
/*
   refcnt--;
   if (refcnt <= 0)
   {
//   exit(0);		
//   Application::quit();   
   printf("Destructor called .. \n");
   }
*/
}


int Application::argc()
{
  return a->argc();
}

char **Application::argv()
{
  return a->argv();
}

Widget *Application::mainWidget()
{
  QWidget *got = a->mainWidget();

  if (Widgets == NULL) return NULL; 

  Widget *w;
  for(w = Widgets->first(); w!=0; w = Widgets->next())
    {
      if(w->widget == got)
	return w;
    }
  return NULL;
}

void Application::setMainWidget(Widget *w)
{
  a->setMainWidget(w->widget);
}

Widget *Application::focusWidget()
{
  QWidget *got;
  Widget *w;
  
  if (Widgets == NULL) return NULL;

  for(w = Widgets->first(); w!=0; w = Widgets->next())
    {
      if(w->widget == got)
	return w;
    }
  return NULL;
}

int Application::exec()
{	
  InsideExecLoop=1;
  return a->exec();
}

void Application::processEvents()
{
  a->processEvents();
}

int Application::enter_loop()
{
  return a->enter_loop();
}

void Application::exit_loop()
{
  a->exit_loop();
}

void Application::quit()
{
  printf("Application QUIT!\n");
  a->quit();
}


void Application::lastWindowClosed()
{
   printf("Application::lastWindowClosed()\n");


   ExitingApplication = 1;	 
   emit("lastWindowClosed", NULL);
  
}

