import sys, Xt, Xm, X, img, imgformat, imgconvert

imgconvert.settrace(1)

error = 'xtestview.error'

vselect = {}

# handle arguments
i = 1
while i < len(sys.argv):
	if sys.argv[i] == '-visualid':
		del sys.argv[i]
		if i == len(sys.argv):
			raise error, '-visualid needs an argument'
		vselect['visualid'] = eval(sys.argv[i])
		del sys.argv[i]
		continue
	if sys.argv[i] == '-depth':
		del sys.argv[i]
		if i == len(sys.argv):
			raise error, '-depth needs an argument'
		vselect['depth'] = eval(sys.argv[i])
		del sys.argv[i]
		continue
	if sys.argv[i] == '-visual':
		del sys.argv[i]
		if i == len(sys.argv):
			raise error, '-visual needs an argument'
		if sys.argv[i] == 'TrueColor':
			vselect['class'] = X.TrueColor
		elif sys.argv[i] == 'PseudoColor':
			vselect['class'] = X.PseudoColor
		else:
			raise error, 'visual type not supported'
		del sys.argv[i]
		continue
	i = i + 1

# default is to use TrueColor visual
if not vselect.has_key('class') and not vselect.has_key('visualid'):
	vselect['class'] = X.TrueColor

# initialize window system
Xt.ToolkitInitialize()
dpy = Xt.OpenDisplay(None, None, 'XTestview', [], sys.argv)

# find deepest visual that satisfies the requirements.
visuals = dpy.GetVisualInfo(vselect)
if not visuals:
	raise error, 'requested visual does not exist'
visual = visuals[0]
for v in visuals:
	if v.depth > visual.depth and v.depth in (8, 24):
		visual = v

if visual.c_class == X.TrueColor:
	vtype = 'TrueColor'
elif visual.c_class == X.PseudoColor:
	vtype = 'PsuedoColor'
else:
	vtype = 'unknown'
print 'Using visual of type %s and depth %d' % (vtype, visual.depth)
# for now ignore the fact that the colors may not be in the right order
if visual.depth == 8:
	format = imgformat.xrgb8
	print 'Using format xrgb8'
elif visual.depth == 24:
	format = imgformat.rgb
	print 'Using format rgb'
else:
	raise error, 'only visuals of depth 8 and 24 supported'

# create a colormap
colormap = visual.CreateColormap(X.AllocNone)
if visual.c_class == X.PseudoColor:
	# allocate colormap entries
	(plane_masks, pixels) = colormap.AllocColorCells(1, 8, 1)
	xcolors = []
	for n in range(256):
		xcolors.append(n + pixels[0],
			       int((((n >> 5) & 7) / 7.) * 255.)<<8,
			       int((((n     ) & 7) / 7.) * 255.)<<8,
			       int((((n >> 3) & 3) / 3.) * 255.)<<8,
			       X.DoRed|X.DoGreen|X.DoBlue)
	colormap.StoreColors(xcolors)
	del plane_masks, pixels, xcolors, n

# create the main widget
main = Xt.CreateApplicationShell('shell', Xt.ApplicationShell,
				 {'visual': visual,
				  'depth': visual.depth,
				  'colormap': colormap,
				  'mappedWhenManaged': X.FALSE})

# clean up a little
del visuals, v, vselect, vtype		# don't need these...

class view:
	def __init__(self, title, fullname):
		self.fullname = fullname
		print 'Reading from',fullname,'...'
		reader = img.reader(format, fullname)
		self.data = reader.read()
		self.width = reader.width
		self.height = reader.height
		self.window = main.CreatePopupShell('shell',
						    Xt.ApplicationShell,
						    {'title': title,
						     'visual': visual,
						     'depth': visual.depth,
						     'colormap': colormap})
		widget = self.window.CreateManagedWidget(
			'image', Xm.DrawingArea,
			{'width': self.width, 'height': self.height})
		self.window.RealizeWidget()
		self.window.Popup(0)
		self.gc = widget.CreateGC({})
		self.image = visual.CreateImage(visual.depth, X.ZPixmap, 0,
						self.data,
						self.width, self.height,
						format.descr['align'], 0)
		widget.AddCallback('exposeCallback', self.expose, None)
		widget.AddCallback('inputCallback', self.input, None)

	def expose(self, w, client_data, call_data):
		self.gc.PutImage(self.image, 0, 0, 0, 0, self.width, self.height)

	def input(self, w, client_data, call_data):
		import Xlib
		event = call_data.event
		if event.type == X.KeyPress:
			string = Xlib.LookupString(event)[0]
			if not string:
				return
			if string[0] in ('w', 'W'):
				self.write()
			if string[0] in ('\033', 'q', 'Q'):
				w.DestroyWidget()
				self.window.DestroyWidget()
				if args:
					a = args[0]
					del args[0]
					view(a, a)
				else:
					raise error

	def write(self):
		import os
		head, tail = os.path.split(self.fullname)
		if not head:
			head = '.'
		newname = head + '/@copy-' + tail
		print 'Writing to',newname,'...'
		try:
		    wrr = img.writer(format, newname)
		except img.unsupported_error, arg:
		    print '** Failed, no converter for', arg[0].name, \
			  'to something supported by this filetype'
		    return
		wrr.width, wrr.height = self.width, self.height
		wrr.write(self.data)

args = sys.argv[1:]
if not args:
	print 'Usage:',sys.argv[0],'file ...'
	sys.exit(1)
a = args[0]
del args[0]
view(a, a)

try:
	Xt.MainLoop()
except error:
	pass
