/***********************************************************
Copyright 1991, 1992, 1993, 1994 by Stichting Mathematisch Centrum,
Amsterdam, The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

/* Use this file as a template to start implementing a new image file
   type module. If you are creating a module to support image files of
   type 'foo', copy to imgfoomodule.c, and replace all occurrences of
   'xxx' by 'foo'. (XXX stands for 'Generic IMage', by the way).

   The intended semantics of using an image reader are as follows:
       import imgxxx
       rdr = imgxxx.newreader('filename')
       x = rdr.x
       y = rdr.y
       data = rdr.read()
   and, for the writer:
       wrr = imgxxx.newwriter('filename')
       wrr.x = x
       wrr.y = y
       wrr.write(data)
   So, to summarize, opening a reader reads the header and stores all
   interesting information in the attributes (which are kept in the 'dict'
   member of the xxxobject structure). For a writer the situation is slightly
   different since the header is written at the write() call.

   The routine xxxselfattr() allows you to easily obtain values from the
   attributes.

   The following routines need massaging:
   - initxxxreader() and initxxxwriter(), and possibly
     xxx_newreader() and xxx_newwriter() (if you need extra args),
   - delxxxreaderobject() and delxxxwriterobject()
   - xxx_read() and xxx_write().
*/

/* Xxx objects */

#include "Python.h"
#include "import.h"

/* XXXX change this to the image formats we support */

static PyObject *format_rgb, *format_rgb_b2t, *format_choices;
extern PyObject *getimgformat();	/* Get foirmat by name */

typedef struct {
	PyObject_HEAD
	PyObject	*dict;		/* Attributes dictionary */
	int	is_reader;	/* TRUE if this is a reader */
	char	*filename;	/* filename of the image file */
	/* Add other (user-invisible) data here */
} xxxobject;

static PyObject *errobject;

staticforward PyTypeObject Xxxtype;

#define is_xxxobject(v)		((v)->ob_type == &Xxxtype)

static char doc_xxx[] =
	"This object can be used to read/write xxximage files.\n"
	"The 'width', 'height' and 'format' attributes give info about the\n"
	"image data read (or to be written)";

/* Routine to easily obtain C data from the dict python data */
int
xxxselfattr(self, name, fmt, ptr, wanterr)
    xxxobject *self;
    char *name;
    char *fmt;
    void *ptr;
    int wanterr;
{
    PyObject *obj;
    char errbuf[100];

    obj = PyDict_GetItemString(self->dict, name);
    if ( obj == NULL ) {
	if ( wanterr ) {
	    sprintf(errbuf, "Required attribute '%s' not set", name);
	    PyErr_SetString(errobject, errbuf);
	    return 0;
	} else {
	    PyErr_Clear();
	    return 0;
	}
    }
    if ( !PyArg_Parse(obj, fmt, ptr) ) {
	if ( !wanterr )
	    PyErr_Clear();
	return 0;
    }
    return 1;
}

/* Routine to easily insert integer into dictionary */
xxxsetintattr(self, name, value)
    xxxobject *self;
    char *name;
    int value;
{
    PyObject *obj;
    int rv;

    obj = PyInt_FromLong(value);
    rv = PyDict_SetItemString(self->dict, name, obj);
    Py_DECREF(obj);
    return rv;
}

static xxxobject *
newxxxobject()
{
	xxxobject *xp;
	xp = PyObject_NEW(xxxobject, &Xxxtype);
	if (xp == NULL)
		return NULL;
	xp->dict = PyDict_New();
	xp->filename = NULL;
	/* XXXX Initialize other pointers here as well */
	return xp;
}

static int
initxxxreader(self, name)
    xxxobject *self;
    char *name;
{
    char *name_copy;

    if( (name_copy=malloc(strlen(name)+1)) == NULL ) {
	PyErr_NoMemory();
	return 0;
    }
    strcpy(name_copy, name);
    self->filename = name_copy;
    self->is_reader = 1;
    /* XXXX Open image file, read header, put into dict: */
    xxxsetintattr(self, "width", 0);
    xxxsetintattr(self, "height", 0);
    PyDict_SetItemString(self->dict, "format", format_rgb);
    PyDict_SetItemString(self->dict, "format_choices", format_choices);
    if( PyErr_Occurred() )
	return 0;
    return 1;
}

static int
initxxxwriter(self, name)
    xxxobject *self;
    char *name;
{
    char *name_copy;

    if( (name_copy=malloc(strlen(name)+1)) == NULL ) {
	PyErr_NoMemory();
	return 0;
    }
    strcpy(name_copy, name);
    self->filename = name_copy;
    self->is_reader = 0;
    PyDict_SetItemString(self->dict, "format", format_rgb);
    PyDict_SetItemString(self->dict, "format_choices", format_choices);
    if( PyErr_Occurred())
	return 0;
    return 1;
}

/* Xxx methods */

static void
xxx_dealloc(xp)
	xxxobject *xp;
{
	Py_XDECREF(xp->dict);
	if( xp->filename )
	    free(xp->filename);
	/* XXXX Free other allocated things here */
	PyMem_DEL(xp);
}

static char doc_read[] = "Read the actual image data as a string";

static PyObject *
xxx_read(self, args)
	xxxobject *self;
	PyObject *args;
{
        PyObject *fmt;
	
	if (!PyArg_ParseTuple(args,""))
		return NULL;
	if (!self->is_reader) {
	    PyErr_SetString(errobject, "Cannot read() from writer object");
	    return NULL;
	}
	/* XXXX Get format (and other args), check, read data, return it */
	if ( !xxxselfattr(self, "format", "O", &fmt, 1) )
	    return NULL;
	if ( fmt == format_rgb ) {
	    /* XXXX do one thing */
	} else {
	    /* XXXX do something else */
	}
	return PyString_FromString("");
}

static char doc_write[] = "Write the image data";

static PyObject *
xxx_write(self, args)
	xxxobject *self;
	PyObject *args;
{
        char *data;
	int datalen;
	int w, h;
	
	if (!PyArg_ParseTuple(args, "s#", &data, &datalen))
		return NULL;
	if (self->is_reader) {
	    PyErr_SetString(errobject, "Cannot write() to reader object");
	    return NULL;
	}
	/* XXXX Get args from self->dict and write the data */
	if ( !xxxselfattr(self, "width", "i", &w, 1) ||
	     !xxxselfattr(self, "height", "i", &h, 1) )
	    return NULL;
	if( w*h != datalen ) {
	    PyErr_SetString(errobject, "Incorrect datasize");
	    return NULL;
	}
	Py_INCREF(Py_None);
	return Py_None;
}

static struct PyMethodDef xxx_methods[] = {
	{"read",	(PyCFunction)xxx_read,	1,	doc_read},
	{"write",	(PyCFunction)xxx_write,	1,	doc_write},
	{NULL,		NULL}		/* sentinel */
};

static PyObject *
xxx_getattr(xp, name)
	xxxobject *xp;
	char *name;
{
        PyObject *v;
	
	if (xp->dict != NULL) {
	        if ( strcmp(name, "__dict__") == 0 ) {
		        Py_INCREF(xp->dict);
			return xp->dict;
		}
		if ( strcmp(name, "__doc__") == 0 ) {
		        return PyString_FromString(doc_xxx);
		}
		v = PyDict_GetItemString(xp->dict, name);
		if (v != NULL) {
			Py_INCREF(v);
			return v;
		}
	}
	return Py_FindMethod(xxx_methods, (PyObject *)xp, name);
}

static int
xxx_setattr(xp, name, v)
	xxxobject *xp;
	char *name;
	PyObject *v;
{
	if (xp->dict == NULL) {
		xp->dict = PyDict_New();
		if (xp->dict == NULL)
			return -1;
	}
	if (v == NULL) {
		int rv = PyDict_DelItemString(xp->dict, name);
		if (rv < 0)
			PyErr_SetString(PyExc_AttributeError,
			        "delete non-existing imgxxx attribute");
		return rv;
	}
	else
		return PyDict_SetItemString(xp->dict, name, v);
}

static PyTypeObject Xxxtype = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,			/*ob_size*/
	"imgxxx",		/*tp_name*/
	sizeof(xxxobject),	/*tp_basicsize*/
	0,			/*tp_itemsize*/
	/* methods */
	(destructor)xxx_dealloc, /*tp_dealloc*/
	0,			/*tp_print*/
	(getattrfunc)xxx_getattr, /*tp_getattr*/
	(setattrfunc)xxx_setattr, /*tp_setattr*/
	0,			/*tp_compare*/
	0,			/*tp_repr*/
	0,			/*tp_as_number*/
	0,			/*tp_as_sequence*/
	0,			/*tp_as_mapping*/
	0,			/*tp_hash*/
};

static char doc_newreader[] = "Create reader for file passed as arg";

static PyObject *
xxx_newreader(self, args)
	PyObject *self;
	PyObject *args;
{
        char *filename;
	xxxobject *obj;
	
	if (!PyArg_ParseTuple(args, "s", &filename))
	    return NULL;
	if ((obj = newxxxobject()) == NULL)
	    return NULL;
	if ( !initxxxreader(obj, filename) ) {
	    xxx_dealloc(obj);
	    return NULL;
	}
	return (PyObject *)obj;
}

static char doc_newwriter[] = "Create writer for file passed as arg";

static PyObject *
xxx_newwriter(self, args)
	PyObject *self;
	PyObject *args;
{
        char *filename;
	xxxobject *obj;
	
	if (!PyArg_ParseTuple(args, "s", &filename))
	    return NULL;
	if ((obj = newxxxobject()) == NULL)
	    return NULL;
	if ( !initxxxwriter(obj, filename) ) {
	    xxx_dealloc(obj);
	    return NULL;
	}
	return (PyObject *)obj;
}


/* List of functions defined in the module */

static struct PyMethodDef xxx_module_methods[] = {
	{"reader",	xxx_newreader,	1,	doc_newreader},
	{"writer",	xxx_newwriter,	1,	doc_newwriter},
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initimgxxx) */
static char doc_imgxxx[] = "Boilerplate for image file access modules";

void
initimgxxx()
{
	PyObject *m, *d, *x, *formatmodule, *formatdict;

	/* Create the module and add the functions */
	m = Py_InitModule("imgxxx", xxx_module_methods);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	errobject = PyString_FromString("imgxxx.error");
	PyDict_SetItemString(d, "error", errobject);
	x = PyString_FromString(doc_imgxxx);
	PyDict_SetItemString(d, "__doc__", x);

	/* Get supported formats */
	if ((formatmodule = PyImport_ImportModule("imgformat")) == NULL)
	    Py_FatalError("imgxxx depends on imgformat");
	if ((formatdict = PyModule_GetDict(formatmodule)) == NULL)
	    Py_FatalError("imgformat has no dict");

	format_rgb = PyDict_GetItemString(formatdict,"rgb");
	format_rgb_b2t = PyDict_GetItemString(formatdict,"rgb_b2t");
	format_choices = Py_BuildValue("(OO)", format_rgb, format_rgb_b2t);

	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module imgxxx");
}
