"Template for image file reader/writers in Python"
#
# Generic image reader/writer module, python version
#
error = 'imgpxxx.error'

class reader:
    "Object that reads the image."
    
    def __init__(self, filename):
	"""Initialize. You should read the header and fill in attributes
	such as width, height, format_choices, format and colormap"""
	
	self._filename = filename
	self.width = 0
	self.height = 0

    def args(self):
	return self.__dict__
	
    def read(self):
	"Read the image data"
	
	return ''

    def write(self, data):
	raise error, 'Cannot write() to reader'

class writer:
    "Object that writes to an image file"
    
    def __init__(self, filename):
	self._filename = filename

    def args(self):
	return self.__dict__
	
    def _get(self, attr):
	try:
	    return getattr(self, attr)
	except AttributeError:
	    raise error, "Required attribute '%s' missing"%attr

    def read(self):
	raise error, 'Cannot read() from writer'


    def write(self, data):
	"""Write the image file, according to attribute format"""
	
	w = self._get('width')
	h = self._get('height')
	if w*h != len(data):
	    raise error, 'Incorrect datasize'
	    
