"""Easy-to-use wrapper module to read and write images in any format,
using any incore representation
"""

##import addpack
##addpack.addpack('/ufs/jack/src/python_mods/img')
import imghdr
import imgppm
import imgpgm
import imgpbm
import imggif
import imgsgi
import imgjpeg
import imgtiff
import imgconvert
import string
import os

from imgconvert import setquality, settrace

error = 'img.error'
unsupported_error = imgconvert.unsupported_error

filedict = {
    'rgb': imgsgi,
    'gif': imggif,
    'pgm': imgpgm,
    'ppm': imgppm,
    'pbm': imgpbm,
    'tiff': imgtiff,
    'tif': imgtiff,
    'jpeg': imgjpeg,
    'jpg': imgjpeg
}

def reader(fmt, filename):
    """Read any imagefile into any in-core format.
    The imagefile is examined to determine what it is.
    Args: format, filename"""
    
    filetype = imghdr.what(filename)
    if not filetype:
	raise error, 'Unknown image file type (bad magic number)'
    if not filedict.has_key(filetype):
	raise error, 'No support for image file type: '+filetype
    module = filedict[filetype]
    rdr = module.reader(filename)
    if fmt == None:
	return rdr
    else:
	return imgconvert.stackreader(fmt, rdr)

def writer(fmt, filename):
    """Write any format imagefile (decided from the extension) from
    any in-core format picture.
    Args: format, filename"""
    
    root, ext = os.path.splitext(filename)
    if ext:
	ext = ext[1:]
    if not filedict.has_key(ext):
	raise error, 'No support for image file type: '+ext
    module = filedict[ext]
    wrr = module.writer(filename)
    if fmt == None:
	return wrr
    else:
	return imgconvert.stackwriter(fmt, wrr)
    
    
