#!/usr/local/bin/python

from string import *
from socket import *
import regsub
import sys
import gd

temps = {}
locs = {"ymml":(130,30),"melb":(150,70),"dunn":(230,70),"ymmb":(170,100),
"fran":(180,140),"cerb":(170,190),"ylvt":(110,80),"grov":(40,150)}
title = []

def parse(file):
	lines = splitfields(file, '\n')
	for line in lines:
		if find(line, '.', 30) > 0:
			fields = split(line)
			temps[fields[0]] = fields[-1]

def getgopher(host, port, get):
	s = socket(AF_INET, SOCK_STREAM)
	s.connect(host, port)
	s.send(get)
	file = ''
	while 1:
		data = s.recv(1024)
		if not data: break
		# replace \012 with \n and get rid of \015
		d1 = regsub.gsub('\015','', data)
		file = file + lower(d1)
	s.close()
	return file

# main proggy
file = getgopher('babel.ho.bom.gov.au',70,'0/Australian Weather Information/Victoria/pmho001\n')
parse(file)

pp = ((0,210) ,(50,180) ,(100,170) ,(110,130) ,(100,130) ,(70,150) ,(50,140)
,(50,130) ,(70,130) ,(140,80) ,(160,80) ,(170,110) ,(180,120) ,(140,190)
,(120,190) ,(100,180) ,(150,220) ,(160,220) ,(180,200) ,(200,200) ,(200,170)
,(210,160) ,(240,160) ,(250,200) ,(240,200) ,(230,220) ,(220,230) ,(220,210)
,(190,210) ,(180,230) ,(210,230) ,(220,240) ,(220,230) ,(260,260))

a=gd.image((260,260))
black = a.colorAllocate((0,0,0))
yellow = a.colorAllocate((200,200,0))
a.lines(pp,yellow)
green = a.colorAllocate((50,90,0))
a.fill((0,0),green)
a.fill((200,220),green)
a.colorTransparent(black)
white = a.colorAllocate((255,255,255))
for loc in temps.keys():
	if loc not in locs.keys(): continue
	a.string(gd.gdFontSmall, locs[loc], temps[loc], white)
print "<html><head><title>Met Observations for Melbourne</title>"
print "<body>"
y=0
for tit in splitfields(file,'\n')[0:2]:
	a.string(gd.gdFontSmall, (10,y), tit, white)
	y=y+10

print "<img src=port_philip.gif><br>"
print splitfields(file,'\n')[2]
a.writeGif("/usr/local/etc/httpd/htdocs/WeatherInfo/port_philip.gif")
