#!/usr/bin/env python
######################################################################
# This module provides a progress bar, analogous to the progress
# sliders in Win 3.1 or the progress slider in Netscape Nav.
# 
# Mitch Chapman
#---------------------------------------------------------------------
# $Log: ProgressBar.py,v $
# Revision 1.1  1996/12/01 22:58:54  mchapman
# Initial revision
#
######################################################################

__version__ = "$Revision: 1.1 $"

import Tkinter; Tk=Tkinter

######################################################################
# This class provides a progress slider embedded within a Tk frame.
######################################################################
class T:
    ##################################################################
    # Initialize a new instance.
    ##################################################################
    def __init__(self, master=None, height=25, fillColor="blue"):
	# Put the sunken relief on the frame, not the canvas.
	# This way, if some subclass decides to embed a window within
	# the canvas, the window won't ever draw itself into the
	# relief area.
	self.master = master
	self.frame = Tk.Frame(master, relief='sunken', bd=2)
	self.canvas = Tk.Canvas(self.frame, height=height, bd=0,
				highlightthickness=0)
	self.scale = self.canvas.create_rectangle(-10, -10, 0, height,
						  fill=fillColor)
	self.canvas.pack(side='top', fill='x', expand='no')

    ##################################################################
    # Specify the completion value for self.
    # percentComplete must be in the range 0..100, inclusive.
    ##################################################################
    def update(self, percentComplete):
	c = self.canvas
	width, height = c.winfo_reqwidth(), c.winfo_reqheight()
	c.coords(self.scale, -10, -10,
		 percentComplete * width / 100.0, height)
	c.update_idletasks()


######################################################################
# Main function for unit testing.
######################################################################
def main():
    class Test:
	def __init__(self):
	    self.progress = T()
	    self.fraction = 0
	    self.progress.frame.pack()
	    self.progress.frame.after(1000, self.update)
	    
	def update(self, event=None):
	    self.fraction = self.fraction + 1
	    self.progress.update(self.fraction)
	    self.progress.frame.after(30, self.update)

    t = Test()
    Tk.mainloop()

if __name__ == "__main__":
    main()
