#!/usr/bin/env python
######################################################################
# This module provides some standard Alert dialogs.
# This is a blatant imitation -- er, flattery -- of the tkdialogs
# package, with extensions.
# 
# Mitch Chapman
#---------------------------------------------------------------------
# $Log: Alerts.py,v $
# Revision 1.1  1996/12/01 22:58:54  mchapman
# Initial revision
#
######################################################################

__version__ = "$Revision: 1.1 $"

import Tkinter; Tk=Tkinter
import Shells, StdDialog, ProgressBar

######################################################################
# This is yer basic Alert type.
######################################################################
class T(Shells.Modal):
    ##################################################################
    # Initialize a new instance.
    ##################################################################
    def __init__(self, master, title="Alert", msg="[your message here]"):
	Shells.Modal.__init__(self, master)
	self.controls = StdDialog.Controls(self)
	self.msg = msg
	self.top.title(title)
	self.justify = "center"

	frame = self.frame = self.controls.frame
	
	bm = self.bitmap = Tk.Label(frame)
	bm.pack(side='left')

	l = self.msgLabel = Tk.Label(frame, text=msg)
	l.pack(side='top', fill='x', expand='yes')

	self.btnBox = self.controls.btnBox

    # For easier override/extend in subclasses
    show = Shells.Modal.show

    ##################################################################
    # Standard callbacks for the various types of buttons.
    ##################################################################
    def okCB(self, event=None):
	self.result = 1
	self.terminate()
	
    def cancelCB(self, event=None):
	self.result = 0
	self.terminate()


######################################################################
# And now for some common alerts:
######################################################################

######################################################################
# Display an error message.
######################################################################
class Error(T):
    def __init__(self, master, title="Error", msg="Error"):
	T.__init__(self, master, title, msg)
	self.bitmap['bitmap'] = 'error'
	self.btnBox.addButtons(["OK", self.okCB])

    # For easier override/extend in subclasses
    show = T.show

    
######################################################################
# Display a warning.
######################################################################
class Warning(T):
    def __init__(self, master, title="Warning", msg="Warning",
		 okLabel="Yes", cancelLabel="No"):
	T.__init__(self, master, title, msg)
	self.bitmap['bitmap'] = 'warning'
	self.btnBox.addButtons([okLabel, self.okCB],
			       [cancelLabel, self.cancelCB])

    # For easier override/extend in subclasses
    show = T.show


######################################################################
# Display a question.
######################################################################
class Question(T):
    def __init__(self, master, title="Question", msg="?",
		 okLabel="Yes", cancelLabel="No"):
	T.__init__(self, master, title, msg)
	self.bitmap['bitmap'] = 'question'
	self.btnBox.addButtons([okLabel, self.okCB],
			       [cancelLabel, self.cancelCB])

    # For easier override/extend in subclasses
    show = T.show


######################################################################
# Display some information.
######################################################################
class Info(T):
    def __init__(self, master, title="Info", msg="I",
		 okLabel="OK"):
	T.__init__(self, master, title, msg)
	self.bitmap['bitmap'] = 'info'
	self.btnBox.addButtons([okLabel, self.okCB])

    # For easier override/extend in subclasses
    show = T.show


######################################################################
# Display instructions for the user.
######################################################################
class Instruction(T):
    def __init__(self, master, title="Instruction", msg="",
		 okLabel="Continue", cancelLabel="Cancel"):
	T.__init__(self, master, title, msg)
	self.bitmap.destroy()
	self.btnBox.addButtons([okLabel, self.okCB],
			       [cancelLabel, self.cancelCB])

    # For easier override/extend in subclasses
    show = T.show


######################################################################
# A progress dialog shows progress, i.e. percent-completion of a task.
######################################################################
class Progress(T):
    def __init__(self, master, title="Progress", msg="",
		 cancelLabel="Cancel"):
	T.__init__(self, master, title, msg)
	self.bitmap.destroy()
	self.progressBar = ProgressBar.T(self.frame)
	self.btnBox.addButtons([cancelLabel, self.cancelCB])
	self.progressBar.frame.pack(fill='x')

    # For easier overriding/extension in  subclasses:
    show = T.show
    
    ##################################################################
    # Update the progress slider.
    # percentComplete should be in the range 0..100, inclusive.
    ##################################################################
    def update(self, percentComplete):
        self.progressBar.update(percentComplete)


######################################################################
# Main function for unit testing.
######################################################################
def main():
    f = Shells.Main()
    l = Tk.Label(f, text="I'm just here for looks,\nreally.")
    l.pack()
    f.pack()
    f.master.geometry("+100+100")
    e = Error(f, msg="An unrecoverable error\nhas occurred.")
    print "Error:", e.show()
    w = Warning(f, msg="Since that error occurred, do you want to go on?")
    print "Warning:", w.show()
    print "Question:", Question(f, msg="No, I mean\ndo you really want\n"
				"to go on?").show()
    print "Info:", Info(f, msg="This parrot is dead.").show()
    print "Instruction:", Instruction(f,
				      msg='Insert a blank tape and press '
				      '"Continue".').show()

    class ProgressTest(Progress):
	def __init__(self, master, title="Progress", msg=""):
	    Progress.__init__(self, master, title, msg)
	    self.value = 0

	def show(self):
	    # Start the timer before showing, because Progress.show
	    # won't return until after the user has dismissed the dialog.
	    self.timerID = self.top.after(500, self.update)
	    result = Progress.show(self)
	    self.top.after_cancel(self.timerID)
	    return result
	
	def update(self, event=None):
	    self.value = self.value + 1
	    Progress.update(self, self.value)
	    if self.value < 100:
		self.timerID = self.top.after(40, self.update)
	    else:
		self.result = 1
		self.terminate()


    print "Progress:", ProgressTest(f,
				    msg="Reading Enc. Britannica").show()
	
    
if __name__ == "__main__":
    main()
