from Tkinter import *

class Dialog(Frame):
	def createWidgets(self):
		# Create the File Select Dialog
		self.dialog = tixFileSelectDialog()
		# Create a button box.
		self.buttons = tixButtonBox()
		# Add a button that will pop up the dialog box.
		self.buttons.add('browse',{"text":"Pick a File...",
					   "command":self.showDialog})
		# Add a quit button.
		self.buttons.add('quit',{"text":"Quit","command":self.quit})
		# Pack the button box.
		self.buttons.pack()
		# Get access to the help button of the dialog box.
		self.dialog.buttons = self.dialog.tixSubwidget(self,'btns')
		self.dialog.buttons.help = self.dialog.buttons.tixSubwidget(self, 'help')
		# The help button will execute .self.showMessage when pressed.
		self.dialog.buttons.help["command"] = self.showMessage
	def showMessage(self):
		# Make a new toplevel window.
		self.new = Toplevel()
		# Put a 'help' message inside of this window.
		self.new.message = Label(self.new,{'text':'A help message could be displayed here..'})
		# Pack it.
		self.new.message.pack({"padx":"7","pady":"7"})
		# Make an 'ok' button that , when pressed, makes the
		# help window go away.
		self.new.ok = Button(self.new,{"text":"OK"})
		self.new.ok.pack()
		self.new.ok["command"] = self.new.destroy
	def showDialog(self):
		# Show the dialog box.
		self.dialog.popup()
	def hideDialog(self):
		# Hide the dialog box.
		self.dialog.popdown()
	def __init__(self, master=None):
		Frame.__init__(self, master)
		Pack.config(self)
		self.createWidgets()

test = Dialog()
test.mainloop()

