//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: vmodule.h
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================

#ifndef VMODULE_H                // Standard technique for avoiding
#define VMODULE_H                // problems with multiple #includes



//
// Uncomment the following definition, if you don't want to get async
// network events. In this case you don't need to patch files
// in V windows version (Right fo V1.14).
// vbasewin.h  
// vwindow.cpp
//
// #define DONT_WANT_PYV_Win_Msg_Process



#include <v/vapp.h>     // We are derived from vApp
#include <v/vawinfo.h>  // Need for app info

#include <v/vmenu.h>    // For the menu pane
#include <v/vcmdwin.h>  // So we can use vCmdWindow
#include <v/vstatusp.h> // For the status pane
#include <v/vcmdpane.h> // command pane

#include <pyv.h>

    class pytApp : public vApp
      {
        friend int AppMain(int, char**); // allow AppMain access

      public:           //---------------------------------------- public

        pytApp(char* appName, int simSDI, int fh, int fw):vApp(appName, simSDI, fh, fw ){};

        virtual ~pytApp() {}

        // Routines from vApp that are normally overridden

        virtual vWindow* NewAppWin(vWindow* win, char* name, int h, int w,
           vAppWinInfo* winInfo);
        virtual void Exit(void);
        virtual void CloseAppWin(vWindow* win);
        virtual void AppCommand(vWindow* win, ItemVal id,
                ItemVal val, CmdType cType);
        virtual void KeyIn(vWindow* win, vKey key,
            unsigned int shift);

        // New routines for this particular app go here

      protected:        //------------------------------------- protected

      private:          //--------------------------------------- private

      };



    class pytCmdWindow : public vCmdWindow
      {
        friend int AppMain(int, char**);        // allow AppMain access

      public:           //---------------------------------------- public
        pytCmdWindow(char*, int, int, 
		PyObject* ,
		PyObject*, 
		PyObject*
#ifdef V_VersionWindows
		,PyObject*
#endif
			 );

        virtual ~pytCmdWindow();          // Destructor
        virtual void WindowCommand(ItemVal id,ItemVal val,CmdType cType);
        virtual void MenuCommand(ItemVal itemId);
        virtual void KeyIn(vKey keysym, unsigned int shift);
#ifdef V_VersionWindows
	virtual int PYV_Win_Msg_Process(HWND hWnd, 
					UINT message, 
					WPARAM wParam, 
					LPARAM lParam);
#endif
      protected:        //------------------------------------- protected

      private:          //--------------------------------------- private


	PyObject *vCmdWindow_cb_KeyIn;
	PyObject *vCmdWindow_cb_MenuCommand;
	PyObject *vCmdWindow_cb_WindowCommand;

#ifdef V_VersionWindows
	PyObject *vCmdWindow_cb_PYV_Win_Msg_Process;
#endif
       };


#endif
