//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvx11.cpp
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================

#include "pyvx11.h"


PyObject * 
Py_vApp_appContext(PyObject* self, PyObject* args)
{
   return Py_BuildValue("l", (PyObject *) theApp->appContext() );
}

PyObject * 
Py_vApp_display(PyObject* self, PyObject* args)
{
   return Py_BuildValue("l", (PyObject *) theApp->display() );
}



static void cb_XtInput(XtPointer client_data, int *fid, XtInputId *id)
{
  PyObject *arglist;
  PyObject *result;
  PyvX11  *pyvX11;
  
  pyvX11=(PyvX11 *) client_data;

  if(pyvX11->cb_Function!= NULL)
  {
    arglist = Py_BuildValue("(i)", pyvX11->Fileno);
    result  = PyEval_CallObject(pyvX11->cb_Function, arglist);
    CHECK_RETURN_RESULT ( result );
    Py_DECREF(arglist);
  }
}


PyObject * 
Py_v_XtAppAddInput(PyObject* self, PyObject* args)
{
   PyvX11  *pyvX11;
   PyObject *objCallBack;
   PyObject *slf;
   int Fileno;
   if (!PyArg_ParseTuple(args, "Oi",
			 &objCallBack,
			 &Fileno))
       return NULL;

   pyvX11= (PyvX11 *)malloc(sizeof(PyvX11));

   if(pyvX11 == NULL)
	    Py_v_FATAL_ERR("Py_XtAddCallback: malloc error.\n");

   ASSIGN_PTR_OF_OBJECT_OR_NULL(objCallBack,  pyvX11->cb_Function);
   Py_INCREF(pyvX11->cb_Function);
   pyvX11->Fileno=Fileno;
   pyvX11->id=XtAppAddInput(theApp->appContext(), 
		Fileno, 
		(XtPointer)  XtInputReadMask, 
		(XtInputCallbackProc) cb_XtInput,
		(XtPointer)  pyvX11);	  

   return Py_BuildValue("l", (PyObject *) pyvX11);
}



PyObject * 
Py_v_XtRemoveInput(PyObject* self, PyObject* args)
{

   PyvX11  *pyvX11;
   if (!PyArg_Parse(args, "l", &pyvX11))
       return NULL;
   XtRemoveInput(pyvX11->id);
   Py_XDECREF(pyvX11->cb_Function );
   free(pyvX11);
   Py_INCREF (Py_None);
   return Py_None;
}


