//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvutls.cc 
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================

#include "pyvutls.h"

PyObject *
Py_vFileSelect(PyObject* self, PyObject* args)
{
    vFileSelect *fsel;
    vBaseWindow *win;
    char *prompt;
    char *filename;
    int maxLen;
    char **ppFilterList;
    int filterIndex;
    PyObject *objList, *objStr;
    int Val, szBytes, i, sizeOfList;
    int rez;
    char *pStr, *pName;
    PyObject *arglist;

    if (!PyArg_Parse(args, "(lssiOi)", 
		     &win,
		     &prompt,
		     &filename,
		     &maxLen,
		     &objList,
		     &filterIndex))
	return NULL;

    pName=(char *)malloc(maxLen+2);
    strcpy(pName, filename);

    sizeOfList=PyList_Size(objList);
    szBytes=sizeof(char *)*(sizeOfList+2);
    ppFilterList=(char **)malloc(szBytes);

    for(i=0; i<sizeOfList; i++)
    {
	objStr=PyList_GetItem(objList,i);
	Py_INCREF(objStr);
	pStr=PyString_AsString(objStr);
	ppFilterList[i]=pStr;
	Py_DECREF(objStr);
    }
    ppFilterList[sizeOfList]=NULL;


    fsel=new vFileSelect(win);

    rez=fsel->FileSelect(prompt,
		     pName,
		     maxLen,
		     ppFilterList,
		     filterIndex);
     arglist = Py_BuildValue("(isi)", 
			  (PyObject *) rez,
			  (PyObject *) pName,
			  (PyObject *) filterIndex);
    free(pName);
    free(ppFilterList);
    delete fsel;
    return  arglist;
}

PyObject *
Py_vFileSelectSave(PyObject* self, PyObject* args)
{
    vFileSelect *fsel;
    vBaseWindow *win;
    char *prompt;
    char *filename;
    int maxLen;
    char **ppFilterList;
    int filterIndex;
    PyObject *objList, *objStr;
    int Val, szBytes, i, sizeOfList;
    int rez;
    char *pStr, *pName;
    PyObject *arglist;

    if (!PyArg_Parse(args, "(lssiOi)", 
		     &win,
		     &prompt,
		     &filename,
		     &maxLen,
		     &objList,
		     &filterIndex))
	return NULL;

    pName=(char *)malloc(maxLen+2);
    strcpy(pName, filename);

    sizeOfList=PyList_Size(objList);
    szBytes=sizeof(char *)*(sizeOfList+2);
    ppFilterList=(char **)malloc(szBytes);

    for(i=0; i<sizeOfList; i++)
    {
	objStr=PyList_GetItem(objList,i);
	Py_INCREF(objStr);
	pStr=PyString_AsString(objStr);
	ppFilterList[i]=pStr;
	Py_DECREF(objStr);
    }
    ppFilterList[sizeOfList]=NULL;


    fsel=new vFileSelect(win);

    rez=fsel->FileSelectSave(prompt,
		     pName,
		     maxLen,
		     ppFilterList,
		     filterIndex);
     arglist = Py_BuildValue("(isi)", 
			  (PyObject *) rez,
			  (PyObject *) pName,
			  (PyObject *) filterIndex);
    free(pName);
    free(ppFilterList);
    delete fsel;
    return  arglist;
}




PyObject *
Py_vFontSelect(PyObject* self, PyObject* args)
{
    vFontSelect *fsel;
    vBaseWindow *win;
    PyObject *arglist;
    vFont *pFont;
    char *pMsg;
    int rez;

    if (!PyArg_ParseTuple(args, "lls", 
		     &win,
		     &pFont,
		     &pMsg))
	return NULL;

    fsel=new vFontSelect(win);
    rez=fsel->FontSelect(*pFont, pMsg);
    arglist = Py_BuildValue("(il)", 
			  (PyObject *) rez, (PyObject *) pFont);
    return  arglist;
}




PyObject *
Py_vNoticeDialog(PyObject* self, PyObject* args)
{
    vBaseWindow *win;
    char *prompt;
    PyObject *arglist;
    vNoticeDialog *note;
    if (!PyArg_Parse(args, "(ls)", 
		     &win,
		     &prompt))
	return NULL;
    note=new vNoticeDialog(win);
    note->Notice(prompt);
    delete note;
    Py_INCREF (Py_None);
    return Py_None;
}







PyObject *
Py_vReplyDialog(PyObject* self, PyObject* args)
{
    vBaseWindow *win;
    char *prompt;
    PyObject *arglist;
    vReplyDialog *rp;
    char *pReply;
    int maxLen, rez;

    if (!PyArg_Parse(args, "(lsi)", 
		     &win,
		     &prompt,
		     &maxLen))
	return NULL;
    pReply=(char *)malloc(maxLen+2);

    rp=new vReplyDialog(win);

    rez=rp->Reply(prompt, pReply, maxLen);

     arglist = Py_BuildValue("(is)", 
			  (PyObject *) rez,
			  (PyObject *) pReply);
    free(pReply);
    delete rp;
    return  arglist;
}



PyObject *
Py_vYNReplyDialog(PyObject* self, PyObject* args)
{
    vBaseWindow *win;
    vYNReplyDialog *pYNd;
    int ans;
    char *pMsg;
    
    if (!PyArg_Parse(args, "ls",
		     &win,
		     &pMsg)) 
	return NULL;
    
    pYNd=new vYNReplyDialog(win);
    ans=pYNd->AskYN(pMsg);
    delete  pYNd;
    return Py_BuildValue("l", (PyObject *) ans);
}


