//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvtimer.cc 
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================



#include "pyvtimer.h"



//====================>>> myTimer::TimerTick <<<====================

pytTimer::pytTimer(PyObject* cb_TimerTick) 
{ 
    _cb_TimerTick=cb_TimerTick; 
    
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_TimerTick, _cb_TimerTick);
    Py_XINCREF(_cb_TimerTick);
}


pytTimer::~pytTimer()
{ 
    Py_XDECREF(_cb_TimerTick);
}




void pytTimer::TimerTick()
{
PyObject *arglist;
PyObject *result;
	arglist = PyTuple_New (0);
	result= PyEval_CallObject(_cb_TimerTick, arglist);
}

PyObject *
Py_vTimer_Constructor(PyObject* self, PyObject* args)
{
	vTimer *pTimer;
	PyObject *cb_TimerTick;
	if (!PyArg_Parse(args, "O", &cb_TimerTick))
		return NULL;
	pTimer = new pytTimer(cb_TimerTick);
        return Py_BuildValue("l", (PyObject *) pTimer);
}



PyObject *
Py_vTimer_Destructor(PyObject* self, PyObject* args)
{
    vTimer *pTimer;
    if (!PyArg_Parse(args, "l", &pTimer))
	return NULL;
    delete pTimer;
    Py_INCREF (Py_None);
    return Py_None;
}
PyObject *
Py_vTimer_TimerSet(PyObject* self, PyObject* args)
{
    long interval;
    vTimer *pTimer;

    if (!PyArg_Parse(args, "(ll)", &pTimer, &interval))
	return NULL;
    return Py_BuildValue("l", (PyObject *) pTimer->TimerSet(interval));
}


PyObject *
Py_vTimer_TimerStop(PyObject* self, PyObject* args)
{
    vTimer *pTimer;
    if (!PyArg_Parse(args, "l", &pTimer))
		return NULL;
    pTimer->TimerStop();
    Py_INCREF (Py_None);
    return Py_None;
}




