//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvprnt.cc
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================

#include "pyvprnt.h"


PyObject * 
Py_vPrintDC_Constructor(PyObject* self, PyObject* args)
{
    vPrintDC* thisDC;
    thisDC = new vPrintDC();
    return Py_BuildValue("l", thisDC);
}


PyObject * 
Py_vPrintDC_Destructor(PyObject* self, PyObject* args)
{
    vPrintDC* thisDC;
    if (!PyArg_Parse(args, "l",	&thisDC))
	return NULL;
    delete thisDC;
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vPrinter_Constructor(PyObject* self, PyObject* args)
{
    vPrinter  *pPrinter;
    pPrinter = new vPrinter();
    return Py_BuildValue("l", pPrinter);
}


PyObject * 
Py_vPrinter_Destructor(PyObject* self, PyObject* args)
{
    vPrinter  *pPrinter;
    if (!PyArg_Parse(args, "l",	&pPrinter))
	return NULL;
    delete pPrinter;
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vPrinter_Setup(PyObject* self, PyObject* args)
{
    vPrinter  *pPrinter;
    char *pFileName;
    if (!PyArg_ParseTuple(args, "ls", &pPrinter, &pFileName))
	return NULL;
    pPrinter->Setup(pFileName);
    Py_INCREF (Py_None);
    return Py_None;
}

