#ifndef PYVMISC_H
#define PYVMISC_H

#include <string.h>

#include "pyv.h"
#include <v/v_defs.h>
#include <v/vdc.h>      // to map colors
#include <v/vkeys.h>    // to map keys
#include <v/vfont.h>    // to map fonts
#include <v/vcanvas.h>  // to map Cursors
#include <v/vtexted.h>  // to map vTextEditior commands


#ifdef V_VersionWindows
#include "winsock.h"
#endif



#include "pyvver.h"




#define Py_v_FUNC_PROTO( func )                         \
extern PyObject *func(PyObject* self, PyObject* args);


Py_v_FUNC_PROTO( Py_vTextCanvasPane_Constructor ) 

Py_v_FUNC_PROTO( Py_vTextCanvasPane_ShowHScroll ) 
Py_v_FUNC_PROTO( Py_vTextCanvasPane_ShowVScroll ) 
Py_v_FUNC_PROTO( Py_vTextCanvasPane_Clear ) 

Py_v_FUNC_PROTO( Py_vTextCanvasPane_ClearRow ) 
Py_v_FUNC_PROTO( Py_vTextCanvasPane_ClearToEnd ) 
Py_v_FUNC_PROTO( Py_vTextCanvasPane_GetCols ) 
Py_v_FUNC_PROTO( Py_vTextCanvasPane_GetRows ) 
Py_v_FUNC_PROTO( Py_vTextCanvasPane_GetRC ) 
Py_v_FUNC_PROTO( Py_vTextCanvasPane_GotoRC ) 
Py_v_FUNC_PROTO( Py_vTextCanvasPane_DrawAttrText ) 
Py_v_FUNC_PROTO( Py_vTextCanvasPane_DrawChar ) 
Py_v_FUNC_PROTO( Py_vTextCanvasPane_DrawText ) 
Py_v_FUNC_PROTO( Py_vTextCanvasPane_HideTextCursor ) 
Py_v_FUNC_PROTO( Py_vTextCanvasPane_ShowTextCursor ) 
Py_v_FUNC_PROTO( Py_vTextCanvasPane_ScrollText ) 
Py_v_FUNC_PROTO( Py_vTextCanvasPane_ResizeText ) 
Py_v_FUNC_PROTO( Py_vTextCanvasPane_SetHScroll )
Py_v_FUNC_PROTO( Py_vTextCanvasPane_SetVScroll )
Py_v_FUNC_PROTO( Py_vTextCanvasPane_Redraw ) 



Py_v_FUNC_PROTO( Py_vFileSelect ) 
Py_v_FUNC_PROTO( Py_vFileSelectSave ) 
Py_v_FUNC_PROTO( Py_vFontSelect ) 
Py_v_FUNC_PROTO( Py_vNoticeDialog ) 
Py_v_FUNC_PROTO( Py_vReplyDialog ) 
Py_v_FUNC_PROTO( Py_vYNReplyDialog );



Py_v_FUNC_PROTO( Py_vDialog_Constructor ) 
Py_v_FUNC_PROTO( Py_vDialog_Destructor ) 
Py_v_FUNC_PROTO( Py_vDialog_AddDialogCmds ) 
Py_v_FUNC_PROTO( Py_vDialog_SetDialogTitle ) 
Py_v_FUNC_PROTO( Py_vDialog_CancelDialog ) 
Py_v_FUNC_PROTO( Py_vDialog_CloseDialog ) 
Py_v_FUNC_PROTO( Py_vDialog_GetDialogPosition ) 
Py_v_FUNC_PROTO( Py_vDialog_GetTextIn ) 
Py_v_FUNC_PROTO( Py_vDialog_GetValue ) 
Py_v_FUNC_PROTO( Py_vDialog_IsDisplayed ) 
Py_v_FUNC_PROTO( Py_vDialog_SetDialogPosition ) 
Py_v_FUNC_PROTO( Py_vDialog_SetValue ) 
Py_v_FUNC_PROTO( Py_vDialog_SetString ) 
Py_v_FUNC_PROTO( Py_vDialog_ShowDialog ) 


Py_v_FUNC_PROTO( Py_vModal_Constructor ) 
Py_v_FUNC_PROTO( Py_vModal_Destructor ) 
Py_v_FUNC_PROTO( Py_vModal_AddDialogCmds ) 
Py_v_FUNC_PROTO( Py_vModal_SetDialogTitle ) 
Py_v_FUNC_PROTO( Py_vModal_CancelDialog ) 
Py_v_FUNC_PROTO( Py_vModal_CloseDialog ) 
Py_v_FUNC_PROTO( Py_vModal_GetDialogPosition ) 
Py_v_FUNC_PROTO( Py_vModal_GetTextIn ) 
Py_v_FUNC_PROTO( Py_vModal_GetValue ) 
Py_v_FUNC_PROTO( Py_vModal_IsDisplayed ) 
Py_v_FUNC_PROTO( Py_vModal_SetDialogPosition ) 
Py_v_FUNC_PROTO( Py_vModal_SetValue ) 
Py_v_FUNC_PROTO( Py_vModal_SetString ) 
Py_v_FUNC_PROTO( Py_vModal_ShowDialog ) 
Py_v_FUNC_PROTO( Py_vModal_ShowModalDialog ) 



Py_v_FUNC_PROTO( Py_vIcon_Constructor );
Py_v_FUNC_PROTO( Py_vIcon_Destructor  );

Py_v_FUNC_PROTO( Py_vFont_Constructor    );
Py_v_FUNC_PROTO( Py_vFont_Destructor     );
Py_v_FUNC_PROTO( Py_vFont_GetFamily      );
Py_v_FUNC_PROTO( Py_vFont_GetPointSize   );
Py_v_FUNC_PROTO( Py_vFont_GetStyle       );
Py_v_FUNC_PROTO( Py_vFont_GetWeight      );
Py_v_FUNC_PROTO( Py_vFont_GetUnderlined  );
Py_v_FUNC_PROTO( Py_vFont_SetFontValues  );


Py_v_FUNC_PROTO( Py_vTimer_Constructor ) 
Py_v_FUNC_PROTO( Py_vTimer_Destructor ) 
Py_v_FUNC_PROTO( Py_vTimer_TimerSet ) 
Py_v_FUNC_PROTO( Py_vTimer_TimerStop ) 



Py_v_FUNC_PROTO( Py_vApp_Constructor );
Py_v_FUNC_PROTO( Py_vApp_doEventLoop );


Py_v_FUNC_PROTO( Py_vApp_AppCommand );
Py_v_FUNC_PROTO( Py_vApp_CloseAppWin );
Py_v_FUNC_PROTO( Py_vApp_Exit );
Py_v_FUNC_PROTO( Py_vApp_KeyIn );
Py_v_FUNC_PROTO( Py_vApp_NewAppWin );
Py_v_FUNC_PROTO( Py_vApp_CheckEvents );
Py_v_FUNC_PROTO( Py_vApp_DefaultHeight );
Py_v_FUNC_PROTO( Py_vApp_DefaultWidth );
Py_v_FUNC_PROTO( Py_vApp_GetDefaultFont );
Py_v_FUNC_PROTO( Py_vApp_GetVVersion );
Py_v_FUNC_PROTO( Py_vApp_IsRunning );
Py_v_FUNC_PROTO( Py_vApp_ScreenHeight );
Py_v_FUNC_PROTO( Py_vApp_ScreenWidth );
Py_v_FUNC_PROTO( Py_vApp_SendWindowCommandAll );
Py_v_FUNC_PROTO( Py_vApp_SetAppTitle );
Py_v_FUNC_PROTO( Py_vApp_SetValueAll );
Py_v_FUNC_PROTO( Py_vApp_SetStringAll );

Py_v_FUNC_PROTO( Py_vApp_ShowList );

Py_v_FUNC_PROTO( Py_vCmdWindow_Constructor );
Py_v_FUNC_PROTO( Py_vCmdWindow_Destructor );
Py_v_FUNC_PROTO( Py_vCmdWindow_GetPosition );
Py_v_FUNC_PROTO( Py_vCmdWindow_GetValue );
Py_v_FUNC_PROTO( Py_vCmdWindow_RaiseWindow );
Py_v_FUNC_PROTO( Py_vCmdWindow_AddPane );
Py_v_FUNC_PROTO( Py_vCmdWindow_GetPosition );
Py_v_FUNC_PROTO( Py_vCmdWindow_GetValue );
Py_v_FUNC_PROTO( Py_vCmdWindow_RaiseWindow );
Py_v_FUNC_PROTO( Py_vCmdWindow_SetValue );
Py_v_FUNC_PROTO( Py_vCmdWindow_SetValueAll );
Py_v_FUNC_PROTO( Py_vCmdWindow_SetPosition );
Py_v_FUNC_PROTO( Py_vCmdWindow_SetString );
Py_v_FUNC_PROTO( Py_vCmdWindow_SetStringAll );
Py_v_FUNC_PROTO( Py_vCmdWindow_SetTitle );
Py_v_FUNC_PROTO( Py_vCmdWindow_ShowPane );
Py_v_FUNC_PROTO( Py_vCmdWindow_ShowWindow );

Py_v_FUNC_PROTO( Py_vCommandPane_Constructor );
Py_v_FUNC_PROTO( Py_vCommandPane_GetTextIn );

Py_v_FUNC_PROTO( Py_vMenuPane_Constructor );
Py_v_FUNC_PROTO( Py_vStatus_Constructor );


Py_v_FUNC_PROTO( Py_vCanvasPane_Constructor      );
Py_v_FUNC_PROTO( Py_vCanvasPane_ShowPane         );
Py_v_FUNC_PROTO( Py_vCanvasPane_SetWidthHeight   );
Py_v_FUNC_PROTO( Py_vCanvasPane_SetCursor        );
Py_v_FUNC_PROTO( Py_vCanvasPane_GetCursor        );
Py_v_FUNC_PROTO( Py_vCanvasPane_UnSetCursor      );
Py_v_FUNC_PROTO( Py_vCanvasPane_SetHScroll       );
Py_v_FUNC_PROTO( Py_vCanvasPane_SetVScroll       );
Py_v_FUNC_PROTO( Py_vCanvasPane_GetHScroll       );
Py_v_FUNC_PROTO( Py_vCanvasPane_GetVScroll       );
Py_v_FUNC_PROTO( Py_vCanvasPane_ShowHScroll      );
Py_v_FUNC_PROTO( Py_vCanvasPane_ShowVScroll      );
Py_v_FUNC_PROTO( Py_vCanvasPane_GetWidth         );
Py_v_FUNC_PROTO( Py_vCanvasPane_GetHeight        );
Py_v_FUNC_PROTO( Py_vCanvasPane_GetDC            );


Py_v_FUNC_PROTO( Py_vDC_Clear            );
Py_v_FUNC_PROTO( Py_vDC_ClearRect        );
Py_v_FUNC_PROTO( Py_vDC_CopyFromMemoryDC );
Py_v_FUNC_PROTO( Py_vDC_DrawArc          );
Py_v_FUNC_PROTO( Py_vDC_DrawAttrText     );
Py_v_FUNC_PROTO( Py_vDC_DrawText         );
Py_v_FUNC_PROTO( Py_vDC_DrawEllipse      );
Py_v_FUNC_PROTO( Py_vDC_DrawIcon         );
Py_v_FUNC_PROTO( Py_vDC_DrawLine         );
Py_v_FUNC_PROTO( Py_vDC_DrawLines        );
Py_v_FUNC_PROTO( Py_vDC_DrawPoint        );
Py_v_FUNC_PROTO( Py_vDC_DrawPoints       );
Py_v_FUNC_PROTO( Py_vDC_DrawPolygon      );
Py_v_FUNC_PROTO( Py_vDC_DrawRoundedRectangle);
Py_v_FUNC_PROTO( Py_vDC_DrawRectangle    );
Py_v_FUNC_PROTO( Py_vDC_DrawRectangles   );
Py_v_FUNC_PROTO( Py_vDC_DrawRubberLine   );
Py_v_FUNC_PROTO( Py_vDC_DrawRubberEllipse);
Py_v_FUNC_PROTO( Py_vDC_DrawRubberPoint  );
Py_v_FUNC_PROTO( Py_vDC_DrawRubberRectangle);
Py_v_FUNC_PROTO( Py_vDC_EndPage          );
Py_v_FUNC_PROTO( Py_vDC_EndPrinting      );
Py_v_FUNC_PROTO( Py_vDC_GetBrush         );
Py_v_FUNC_PROTO( Py_vDC_SetBrush         );
Py_v_FUNC_PROTO( Py_vDC_BeginPrinting    );
Py_v_FUNC_PROTO( Py_vDC_BeginPage        );
Py_v_FUNC_PROTO( Py_vDC_GetPhysHeight    );
Py_v_FUNC_PROTO( Py_vDC_GetPhysWidth     );
Py_v_FUNC_PROTO( Py_vDC_SetBackground    );
Py_v_FUNC_PROTO( Py_vDC_SetScale         );
Py_v_FUNC_PROTO( Py_vDC_GetScale         );
Py_v_FUNC_PROTO( Py_vDC_SetTranslate     );
Py_v_FUNC_PROTO( Py_vDC_SetTransX        );
Py_v_FUNC_PROTO( Py_vDC_SetTransY        );
Py_v_FUNC_PROTO( Py_vDC_GetTranslate     );
Py_v_FUNC_PROTO( Py_vDC_GetTransX        );
Py_v_FUNC_PROTO( Py_vDC_GetTransY        );
Py_v_FUNC_PROTO( Py_vDC_SetFont          );
Py_v_FUNC_PROTO( Py_vDC_GetFont          );
Py_v_FUNC_PROTO( Py_vDC_SetPen           );
Py_v_FUNC_PROTO( Py_vDC_GetPen           );
Py_v_FUNC_PROTO( Py_vDC_SetPrinter       );
Py_v_FUNC_PROTO( Py_vDC_TextHeight       );
Py_v_FUNC_PROTO( Py_vDC_TextWidth        );

Py_v_FUNC_PROTO( Py_vBrush_Constructor   );
Py_v_FUNC_PROTO( Py_vBrush_Destructor    );
Py_v_FUNC_PROTO( Py_vBrush_GetColor      );
Py_v_FUNC_PROTO( Py_vBrush_GetFillMode   );
Py_v_FUNC_PROTO( Py_vBrush_GetStyle      );
Py_v_FUNC_PROTO( Py_vBrush_SetColor      );
Py_v_FUNC_PROTO( Py_vBrush_SetFillMode   );
Py_v_FUNC_PROTO( Py_vBrush_SetStyle      );

Py_v_FUNC_PROTO( Py_vColor_Constructor   );
Py_v_FUNC_PROTO( Py_vColor_Destructor    );
Py_v_FUNC_PROTO( Py_vColor_BitsOfColor   );
Py_v_FUNC_PROTO( Py_vColor_ResetColor    );
Py_v_FUNC_PROTO( Py_vColor_Set           );
Py_v_FUNC_PROTO( Py_vColor_SetR          );
Py_v_FUNC_PROTO( Py_vColor_SetG          );
Py_v_FUNC_PROTO( Py_vColor_SetB          );
Py_v_FUNC_PROTO( Py_vColor_r             );
Py_v_FUNC_PROTO( Py_vColor_g             );
Py_v_FUNC_PROTO( Py_vColor_b             );

Py_v_FUNC_PROTO( Py_vPen_Constructor     );
Py_v_FUNC_PROTO( Py_vPen_Destructor      );
Py_v_FUNC_PROTO( Py_vPen_GetColor        );
Py_v_FUNC_PROTO( Py_vPen_GetStyle        );
Py_v_FUNC_PROTO( Py_vPen_GetWidth        );
Py_v_FUNC_PROTO( Py_vPen_SetColor        );
Py_v_FUNC_PROTO( Py_vPen_SetStyle        );
Py_v_FUNC_PROTO( Py_vPen_SetWidth        );

Py_v_FUNC_PROTO( Py_vMemoryDC_Constructor);
Py_v_FUNC_PROTO( Py_vMemoryDC_Destructor );

Py_v_FUNC_PROTO( Py_vPrintDC_Constructor );
Py_v_FUNC_PROTO( Py_vPrintDC_Destructor  );
Py_v_FUNC_PROTO( Py_vPrinter_Constructor );
Py_v_FUNC_PROTO( Py_vPrinter_Destructor  );
Py_v_FUNC_PROTO( Py_vPrinter_Setup       );

Py_v_FUNC_PROTO( Py_vTextEditor_Constructor   );
Py_v_FUNC_PROTO( Py_vTextEditor_Destructor    );
Py_v_FUNC_PROTO( Py_vTextEditor_resetBuff     );
Py_v_FUNC_PROTO( Py_vTextEditor_addLine       );
Py_v_FUNC_PROTO( Py_vTextEditor_getFirstLine  );
Py_v_FUNC_PROTO( Py_vTextEditor_getNextLine   );
Py_v_FUNC_PROTO( Py_vTextEditor_getLine       );
Py_v_FUNC_PROTO( Py_vTextEditor_displayBuff   );
Py_v_FUNC_PROTO( Py_vTextEditor_EditCommand   );
Py_v_FUNC_PROTO( Py_vTextEditor_EditKeyIn     );

Py_v_FUNC_PROTO( Py_vDebugDialog_Constructor   );
Py_v_FUNC_PROTO( Py_vDebugDialog_Destructor    );
Py_v_FUNC_PROTO( Py_vDebugDialog_SetDebug      );
Py_v_FUNC_PROTO( Py_vDebugDialog_DialogCommand );

Py_v_FUNC_PROTO( Py_pyvTraceFileOpen           );
Py_v_FUNC_PROTO( Py_pyvTraceFileClose          );
Py_v_FUNC_PROTO( Py_pyvTraceFileFlush          );
Py_v_FUNC_PROTO( Py_pyvTraceFileFlushMode      );

Py_v_FUNC_PROTO( Py_pyvTrace_Display           );

#ifdef V_VersionWindows
Py_v_FUNC_PROTO( Py_v_W95_WSAAsyncSelect       );
Py_v_FUNC_PROTO( Py_v_W95_WSAGetLastError      );

Py_v_FUNC_PROTO( Py_v_W95_GetLastError         );
Py_v_FUNC_PROTO( Py_v_W95_MoveWindow           );
Py_v_FUNC_PROTO( Py_v_W95_SendMessage          );
#endif


#ifdef V_VersionX
Py_v_FUNC_PROTO( Py_vApp_display );
Py_v_FUNC_PROTO( Py_vApp_appContext );
Py_v_FUNC_PROTO( Py_v_XtAppAddInput);
Py_v_FUNC_PROTO( Py_v_XtRemoveInput);
#endif


//Py_v_FUNC_PROTO(         );


#endif
