//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvicon.cc
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================

#include "pyvicon.h"

//
// getBaseAndExt function is derived from ../iconed/viedcnv.cpp 
// Follows a Copyright of this file.
//
//    //========================= viedcnv.cxx =================================
//    // This is the source file for the icon editor picture class, the color
//    // palette class, and the canvas pane class.   -
//    //
//    // Copyright (C) 1996 Philip Eckenroth, Mike Tipping, Marilee Padilla,
//    //                    John Fredric Jr. Masciantoni, and Bruce E. Wampler.
//    //
//    // This file is part of the V Icon Editor, and is covered
//    // under the terms of the GNU General Public License,
//    // Version 2. This program has NO WARRANTY. See the source file
//    // viedapp.cpp for more complete information about license terms.
//    //=======================================================================
//
//
int getBaseAndExt(char* name, char* base, char* ext)
{
    char temp_str[256];
    int ix;
    
    strcpy(temp_str,name);
    
    for (ix = strlen(temp_str) - 1 ; ix >= 0 ; --ix)
    {
	if (temp_str[ix] == '.')	// found break
	{
	    strcpy(ext,&temp_str[ix+1]);
	    temp_str[ix] = 0;
	    break;
	}
	if (temp_str[ix] == '/' || temp_str[ix] == '\\')
	    break;
    }
    
    for ( ; ix >= 0 ; --ix)
    {
	if (temp_str[ix] == '/' || temp_str[ix] == '\\')
	{
	    strcpy(base,&temp_str[ix+1]);
	    break;
	}
    }
    
    if (ix <= 0 &&
	temp_str[0] != '/' && temp_str[0] != '\\')
    {
	strcpy(base,&temp_str[0]);
    }
    
    for (char *cp = base ; *cp ; ++cp)
	*cp = tolower(*cp);
    return 1;
}



PyObject *
Py_vIcon_Constructor(PyObject* self, PyObject* args)
{
    vIcon *pIcon;
    char *filename;
    int Height, Width, Depth;
    iconIO  *icn;
    unsigned char *pBuf;
    int len, stat, MemSiz;
    char strip_name[256], ext[256];
    int flgReadOk=0;

    if (!PyArg_Parse(args, "s",
			  &filename
			  ))
	return NULL;
    icn = new iconIO(600, 600);


    if (!filename || !*filename)
	return 0;

    getBaseAndExt(filename, strip_name, ext);

    if (strcmp(ext,"vbm") == 0 || strcmp(ext,"VBM") == 0)
      {
	if (!icn->ReadVBM(filename))		// Read a VBM image
    	    return Py_BuildValue("(liiii)", (PyObject *) NULL ,0, 0, 0, 0);
	flgReadOk=1;
      }

    if (strcmp(ext,"xpm") == 0 || strcmp(ext,"XPM") == 0)
      {
	if (!icn->ReadXPM(filename))		// Read a XPM image
    	    return Py_BuildValue("(liiii)", (PyObject *) NULL,0, 0, 0, 0);
	flgReadOk=1;
      }

    if (strcmp(ext,"xbm") == 0 || strcmp(ext,"XBM") == 0)
      {
	if (!icn->ReadXBM(filename))		// Read a XBM image
    	    return Py_BuildValue("(liiii)", (PyObject *) NULL,0, 0, 0, 0);
	flgReadOk=1;
      }

    if (strcmp(ext,"bmp") == 0 || strcmp(ext,"BMP") == 0)
      {
	if (!icn->ReadBMP(filename))		// Read a BMP image
    	    return Py_BuildValue("(liiii)", (PyObject *) NULL,0, 0, 0, 0);
	flgReadOk=1;
      }
    
    if(!flgReadOk)
    	return Py_BuildValue("l", (PyObject *) NULL);


    if (icn->Depth() == 1)
    {
	MemSiz=(icn->Height()*icn->Width()/8);
#ifdef IcnDebug
	printf("\nDepth==1 Mem=%d\n",MemSiz);
#endif
    }
    if (icn->Depth() == 8)
    {
	MemSiz=1+icn->Colors()*3  +  icn->Height()*icn->Width();
#ifdef IcnDebug
	printf("\nDepth==8 Mem=%d\n",MemSiz);
#endif
    }
    if (icn->Depth() == 24)
    {
	MemSiz= icn->Height()*icn->Width();
#ifdef IcnDebug
	printf("\nDepth==24 Mem=%d\n",MemSiz);
#endif
    }


    pBuf=(unsigned char *)malloc(MemSiz+10);

    icn->MemVBM((char *) pBuf, len, Height, Width, Depth);

#ifdef IcnDebug
  printf("\nActual Memory Size Is -> %d\n",  len);
#endif

    pIcon = new vIcon(pBuf, Height,  Width, Depth);

    return Py_BuildValue("(liiii)", (PyObject *) pIcon, len, Height, Width, Depth);
}




PyObject *
Py_vIcon_Destructor(PyObject* self, PyObject* args)
{
    vIcon *pIcon;
    if (!PyArg_Parse(args, "l",
		     &pIcon
		     ))
	return NULL;
    free(pIcon->icon);
    delete pIcon;
    Py_INCREF (Py_None);
    return Py_None;
}





//==================>>> iconIO::MemVBM <<<====================
int iconIO::MemVBM(char* pMem, int& len, int& Height, int& Width, int& Depth)
{
    // Write out the image save in the data structure
	
    if (_pixels == 0 || !_r || !_g || !_b)
	return 0;

    len = 0;

    if (_depth == 1 || 
	(_colors == 2 && 
	 (((_r[0] == 0 && _g[0] == 0 && _b[0] == 0) &&
	   (_r[1] == 255 && _g[1] == 255 && _b[1] == 255)) ||
	  ((_r[1] == 0 && _g[1] == 0 && _b[1] == 0) &&
	   (_r[0] == 255 && _g[0] == 255 && _b[0] == 255)))))
    {
        Depth=1;
	int res = MemRestOfXBM(pMem, len, Height, Width, Depth, 1);
	return res;
    }
    else 
    if (_depth == 8)
    {
	Depth=_depth;
	Width=_width;
	Height=_height;
	*(pMem++)=(_colors - 1); len++;
	for (int ic = 0 ; ic < _colors ; ++ic)
	{
	    *(pMem++)=  (char) _r[ic];   len++;
	    *(pMem++)=  (char) _g[ic];   len++;
	    *(pMem++)=  (char) _b[ic];   len++;
	}
	if (_width < 32)                // neat format if narrow
	{
	    long px = 0;
	    for (int ir = 0 ; ir < _height ; ++ir)
	    {
                for (int ic = 0 ; ic < _width ; ++ic)
		    *(pMem++)=  (char) _pixels[px++];
	    }
	    return 1;  // sofin
	}
        else
	{
	    long lx;
            long limit = _width * _height;
            for (lx = 0 ; lx < (limit - 1) ; )
	    {
	        *(pMem++)=  (char) _pixels[lx++];    len++;
	    }
	    *(pMem++)=  (char) _pixels[lx];   len++;
	}
        return 1;
    }
    else 
   if (_depth == 24)
	return 0;
   return 0;   // sofin 
}


//==================>>> iconIO::MemRestOfXBM <<<====================
int iconIO::MemRestOfXBM(char *pMem, int& len, int& Height, int& Width, int& Depth, int isVBM)
{
    
    int  i,j,k,bit,flipbw;
    long pix;
    char buff[20];
    
    Width   = _width;
    Height  = _height;
    
    flipbw = (_r[0] == 0);	
    
    for (i=0, pix = 0 ; i < _height ; i++)
    {
	for (j = bit = k = 0 ; j < _width ; j++)
	{
	    k = (k>>1);
	    if (_pixels[pix++])
		k |= 0x80;
	    bit++;
	    if (bit == 8)
	    {
		if (flipbw)
		    k = ~k;
		*(pMem++)=(char)k&0xff;   len++;
		bit = k = 0;
	    }
	}
	if (bit)
	{
	    k = k >> (8-bit);
	    if (flipbw) 
		k = ~k;
	    *(pMem++)=(char)k&0xff;   len++;
	}
    }
    return 1;
}
