//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvdialg.cc
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================

#include "pyvdialg.h"


//==========================>>> pytDialog::pytDialog <<<======================
  pytDialog::pytDialog(vBaseWindow* bw, PyObject *cb_DialogCommand) :
    vDialog(bw)
  {
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_DialogCommand, vDialog_cb_DialogCommand  );
    Py_XINCREF( vDialog_cb_DialogCommand  );

  }

//=========================>>> pytDialog::~pytDialog <<<======================
  pytDialog::~pytDialog()
  {
    Py_XDECREF( vDialog_cb_DialogCommand  );
  }


//====================>>> pytDialog::DialogCommand <<<======================
void pytDialog::DialogCommand(ItemVal id, ItemVal retval, CmdType ctype)
{
    PyObject *arglist;
    PyObject *result;


    if(vDialog_cb_DialogCommand==NULL)
	return;

	arglist = Py_BuildValue("(iii)", id, retval, ctype);
	result  = PyEval_CallObject(vDialog_cb_DialogCommand, arglist);
	CHECK_RETURN_RESULT ( result );
	Py_DECREF(arglist);
}

//======================================================================
//======================================================================
//======================================================================


PyObject * 
Py_vDialog_Constructor(PyObject* self, PyObject* args)
{
    pytDialog* thisDialog;
    vBaseWindow* win;
    PyObject *cb_DialogCommand;
    if (!PyArg_ParseTuple(args, "iO",
			  &win,
			  &cb_DialogCommand
			  ))
	return NULL;
    thisDialog = new pytDialog(win, cb_DialogCommand);
    return Py_BuildValue("l", thisDialog);
}

PyObject * 
Py_vDialog_Destructor(PyObject* self, PyObject* args)
{
    pytDialog* thisDialog;

    if (!PyArg_Parse(args, "l",
			  &thisDialog
			  ))
	return NULL;
    delete thisDialog;
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDialog_AddDialogCmds(PyObject* self, PyObject* args)
{
    pytDialog* thisDialog;
    PyObject *objList;
    CommandObject *pCmdObject;

    if (!PyArg_ParseTuple(args, "lO",
			  &thisDialog,
			  &objList
			  ))
	return NULL;

    pCmdObject=ProcessCommandObject(objList);

    thisDialog->AddDialogCmds(pCmdObject);

    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDialog_SetDialogTitle(PyObject* self, PyObject* args)
{
    pytDialog* thisDialog;
    char *pTitle;
    if (!PyArg_ParseTuple(args, "ls",
			  &thisDialog,
			  &pTitle
			  ))
	return NULL;
    thisDialog->SetDialogTitle(pTitle);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDialog_CancelDialog(PyObject* self, PyObject* args)
{
    pytDialog* thisDialog;
    if (!PyArg_Parse(args, "l",
			  &thisDialog
			  ))
	return NULL;
    thisDialog->CancelDialog();
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDialog_CloseDialog(PyObject* self, PyObject* args)
{
    pytDialog* thisDialog;
    if (!PyArg_Parse(args, "l",
			  &thisDialog
			  ))
	return NULL;
    thisDialog->CloseDialog();
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDialog_GetDialogPosition(PyObject* self, PyObject* args)
{
    pytDialog* thisDialog;
    ItemVal Id;
    int left, top, width, height;

    if (!PyArg_Parse(args, "l",
			  &thisDialog
			  ))
	return NULL;

    thisDialog->GetDialogPosition(left, top, width, height);
    return Py_BuildValue("(iiii)", left, top, width, height);
}



PyObject * 
Py_vDialog_GetTextIn(PyObject* self, PyObject* args)
{
    pytDialog* thisDialog;
    ItemVal Id;
    char *pBuf;
    PyObject *arglist;

#define MAX_BUFFER_LEN_GetTextIn    1000

    if (!PyArg_ParseTuple(args, "li",
			  &thisDialog,
			  &Id
			  ))
	return NULL;
    pBuf=(char *)malloc(MAX_BUFFER_LEN_GetTextIn);

    if(pBuf==NULL)
	        Py_v_FATAL_ERR("\nPy_vDialog_GetTextIn: pCmdObject malloc error.\n");

    thisDialog->GetTextIn(Id, pBuf, MAX_BUFFER_LEN_GetTextIn);
    arglist = Py_BuildValue("s", pBuf);
    free(pBuf);
    return arglist;
}



PyObject * 
Py_vDialog_GetValue(PyObject* self, PyObject* args)
{
    pytDialog* thisDialog;
    ItemVal Id;
    int res;

    if (!PyArg_ParseTuple(args, "li",
			  &thisDialog,
			  &Id
			  ))
	return NULL;
    res=thisDialog->GetValue(Id);
    return Py_BuildValue("l", res);
}



PyObject * 
Py_vDialog_IsDisplayed(PyObject* self, PyObject* args)
{
    pytDialog* thisDialog;
    ItemVal Id;
    int res;

    if (!PyArg_Parse(args, "l",
			  &thisDialog
			  ))
	return NULL;
    res=thisDialog->IsDisplayed();
    return Py_BuildValue("i", res);
}


PyObject * 
Py_vDialog_SetDialogPosition(PyObject* self, PyObject* args)
{
    pytDialog* thisDialog;
    ItemVal Id;
    int left, top;

    if (!PyArg_ParseTuple(args, "lii",
			  &thisDialog,
			  &left, 
			  &top
			  ))
	return NULL;
    thisDialog->SetDialogPosition(left, top);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDialog_SetValue(PyObject* self, PyObject* args)
{
    pytDialog* thisDialog;
    ItemVal Id, Val;
    ItemSetType type;

    if (!PyArg_ParseTuple(args, "liii",
			  &thisDialog,
			  &Id,
			  &Val,
			  &type
			  ))
	return NULL;
    thisDialog->SetValue(Id, Val, type);
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vDialog_SetString(PyObject* self, PyObject* args)
{
    pytDialog* thisDialog;
    ItemVal Id;
    char *str;

    if (!PyArg_ParseTuple(args, "lis",
			  &thisDialog,
			  &Id,
			  &str
			  ))
	return NULL;
    thisDialog->SetString(Id, str);
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vDialog_ShowDialog(PyObject* self, PyObject* args)
{
    pytDialog* thisDialog;
    char *msg;

    if (!PyArg_ParseTuple(args, "ls",
			  &thisDialog,
			  &msg
			  ))
	return NULL;
    thisDialog->ShowDialog(msg);
    Py_INCREF (Py_None);
    return Py_None;
}





