//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvcolr.cc 
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================

#include "pyvcolr.h"


PyObject *
Py_vColor_Constructor(PyObject* self, PyObject* args)
{
    vColor *pColor;
    unsigned int r, g, b;
    
    if (!PyArg_ParseTuple(args, "iii",
			  &r,
			  &g,
			  &b))
	return NULL;

    pColor= new vColor(r, g, b);

    return Py_BuildValue("l", (PyObject *) pColor);
}
    

PyObject *
Py_vColor_Destructor(PyObject* self, PyObject* args)
{
    vColor *pColor;
    if (!PyArg_Parse(args, "l",
		     &pColor
		     ))
	return NULL;
    delete pColor;
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject *
Py_vColor_BitsOfColor(PyObject* self, PyObject* args)
{
    vColor *pColor;
    if (!PyArg_Parse(args, "l",
		     &pColor
		     ))
	return NULL;
    return Py_BuildValue("i", (PyObject *) pColor->BitsOfColor() );
}


PyObject *
Py_vColor_ResetColor(PyObject* self, PyObject* args)
{
    vColor *pColor;
    int r, g, b;
    if (!PyArg_ParseTuple(args, "liii",
			  &pColor,
			  &r,
			  &g, 
			  &b
			  ))
	return NULL;
    pColor->ResetColor(r, g, b);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject *
Py_vColor_Set(PyObject* self, PyObject* args)
{
    vColor *pColor;
    int r, g, b;
    if (!PyArg_ParseTuple(args, "liii",
			  &pColor,
			  &r,
			  &g, 
			  &b
			  ))
	return NULL;
    pColor->Set(r, g, b);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject *
Py_vColor_SetR(PyObject* self, PyObject* args)
{
    vColor *pColor;
    int c;
    if (!PyArg_ParseTuple(args, "li",
			  &pColor,
			  &c
			  ))
	return NULL;
    pColor->SetR(c);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject *
Py_vColor_SetG(PyObject* self, PyObject* args)
{
    vColor *pColor;
    int c;
    if (!PyArg_ParseTuple(args, "li",
			  &pColor,
			  &c
			  ))
	return NULL;
    pColor->SetG(c);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject *
Py_vColor_SetB(PyObject* self, PyObject* args)
{
    vColor *pColor;
    int c;
    if (!PyArg_ParseTuple(args, "li",
			  &pColor,
			  &c
			  ))
	return NULL;
    pColor->SetB(c);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject *
Py_vColor_r(PyObject* self, PyObject* args)
{
    vColor *pColor;
    if (!PyArg_Parse(args, "l",
		     &pColor
		     ))
	return NULL;
    return Py_BuildValue("i", pColor->r() );
}

PyObject *
Py_vColor_g(PyObject* self, PyObject* args)
{
    vColor *pColor;
    if (!PyArg_Parse(args, "l",
		     &pColor
		     ))
	return NULL;
    return Py_BuildValue("i", pColor->g() );
}


PyObject *
Py_vColor_b(PyObject* self, PyObject* args)
{
    vColor *pColor;
    if (!PyArg_Parse(args, "l",
		     &pColor
		     ))
	return NULL;
    return Py_BuildValue("i", pColor->b() );
}
