//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvcnvst.cc
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================


#include "pyvcnvst.h"            // include our header file

//======================================================================
  pytTextCanvasPane::pytTextCanvasPane(	
	PyObject *cb_TextMouseDown,
	PyObject *cb_TextMouseUp,
	PyObject *cb_TextMouseMove,
        PyObject *cb_HPage,
        PyObject *cb_HScroll,
        PyObject *cb_VPage,  
        PyObject *cb_VScroll,
       	PyObject *cb_ResizeText,
	PyObject *cb_Redraw
	):vTextCanvasPane()
{


	
	ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_TextMouseUp,   vTextCanvasPane_cb_TextMouseUp   );
	ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_TextMouseDown, vTextCanvasPane_cb_TextMouseDown );
	ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_TextMouseMove, vTextCanvasPane_cb_TextMouseMove );

	ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_HPage,         vTextCanvasPane_cb_HPage   );
	ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_HScroll,       vTextCanvasPane_cb_HScroll );
	ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_VPage,         vTextCanvasPane_cb_VPage   );
	ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_VScroll,       vTextCanvasPane_cb_VScroll );
	ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_ResizeText,    vTextCanvasPane_cb_ResizeText );
	ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_Redraw,         vTextCanvasPane_cb_Redraw );


	Py_XINCREF( vTextCanvasPane_cb_TextMouseDown    );
	Py_XINCREF( vTextCanvasPane_cb_TextMouseUp      );
	Py_XINCREF( vTextCanvasPane_cb_TextMouseMove    );
	Py_XINCREF( vTextCanvasPane_cb_HPage            );
	Py_XINCREF( vTextCanvasPane_cb_HScroll          );
	Py_XINCREF( vTextCanvasPane_cb_VPage            );
	Py_XINCREF( vTextCanvasPane_cb_VScroll          );
	Py_XINCREF( vTextCanvasPane_cb_ResizeText       );
	Py_XINCREF( vTextCanvasPane_cb_Redraw           );
}


//======================================================================
pytTextCanvasPane::~pytTextCanvasPane()
{
	Py_XDECREF(  vTextCanvasPane_cb_TextMouseDown     );
	Py_XDECREF(  vTextCanvasPane_cb_TextMouseUp       );
	Py_XDECREF(  vTextCanvasPane_cb_TextMouseMove     );
	Py_XDECREF(  vTextCanvasPane_cb_HPage             );
	Py_XDECREF(  vTextCanvasPane_cb_HScroll           );
	Py_XDECREF(  vTextCanvasPane_cb_VPage             );
	Py_XDECREF(  vTextCanvasPane_cb_VScroll           );
	Py_XDECREF(  vTextCanvasPane_cb_ResizeText        );
	Py_XDECREF(  vTextCanvasPane_cb_Redraw            );
  
}

//======================================================================
//======================================================================
//======================================================================
void pytTextCanvasPane::TextMouseDown(int row, int col, int button)
{
  PyObject *arglist,*result;
  if(vTextCanvasPane_cb_TextMouseDown != NULL)
  {
     arglist = Py_BuildValue("(iii)", row, col, button);
     result  = PyEval_CallObject(vTextCanvasPane_cb_TextMouseDown, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}
//======================================================================
void pytTextCanvasPane::TextMouseUp(int row, int col, int button)
{
  PyObject *arglist,*result;
  if(vTextCanvasPane_cb_TextMouseUp != NULL)
  {
     arglist = Py_BuildValue("(iii)", row, col, button);
     result  = PyEval_CallObject(vTextCanvasPane_cb_TextMouseUp, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}
//======================================================================
void pytTextCanvasPane::TextMouseMove(int row, int col, int button)
{
  PyObject *arglist,*result;
  if(vTextCanvasPane_cb_TextMouseMove != NULL)
  {
     arglist = Py_BuildValue("(iii)", row, col, button);
     result  = PyEval_CallObject(vTextCanvasPane_cb_TextMouseMove, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}

//======================================================================
void pytTextCanvasPane::VPage(int Shown, int Top)
{
 PyObject *arglist,*result;
  if(vTextCanvasPane_cb_VPage!= NULL)
  {
     arglist = Py_BuildValue("(ii)", Shown, Top);
     result  = PyEval_CallObject(vTextCanvasPane_cb_VPage, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}
//======================================================================
void pytTextCanvasPane::HPage(int Shown, int Top)
{
 PyObject *arglist,*result;
  if(vTextCanvasPane_cb_HPage!= NULL)
  {
     arglist = Py_BuildValue("(ii)", Shown, Top);
     result  = PyEval_CallObject(vTextCanvasPane_cb_HPage, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}

//======================================================================
void pytTextCanvasPane::VScroll(int step)
{
 PyObject *arglist,*result;
  if(vTextCanvasPane_cb_VScroll!= NULL)
  {
     arglist = Py_BuildValue("(i)", step);
     result  = PyEval_CallObject(vTextCanvasPane_cb_VScroll, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}
//======================================================================
void pytTextCanvasPane::HScroll(int step)
{
 PyObject *arglist,*result;
  if(vTextCanvasPane_cb_HScroll!= NULL)
  {
     arglist = Py_BuildValue("(i)", step);
     result  = PyEval_CallObject(vTextCanvasPane_cb_HScroll, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}

//======================================================================
void pytTextCanvasPane::ResizeText(const int rows, const int cols)
{
 PyObject *arglist,*result;
  if(vTextCanvasPane_cb_ResizeText!= NULL)
  {
     arglist = Py_BuildValue("(ii)", rows, cols);
     result  = PyEval_CallObject(vTextCanvasPane_cb_ResizeText, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}

//======================================================================
void pytTextCanvasPane::Redraw(int x, int y, int width, int height)
{
 PyObject *arglist,*result;

  vTextCanvasPane::Redraw(x, y, height, width);

  if(vTextCanvasPane_cb_Redraw!= NULL)
  {
     arglist = Py_BuildValue("(iiii)", x, y, height, width);
     result  = PyEval_CallObject(vTextCanvasPane_cb_Redraw, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}



//======================================================================
//======================================================================
//======================================================================


PyObject * 
Py_vTextCanvasPane_Constructor(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;

	PyObject *vTextCanvasPane_cb_TextMouseDown;
	PyObject *vTextCanvasPane_cb_TextMouseUp;
	PyObject *vTextCanvasPane_cb_TextMouseMove;
	PyObject *vTextCanvasPane_cb_HPage;
	PyObject *vTextCanvasPane_cb_HScroll;
	PyObject *vTextCanvasPane_cb_VPage;
	PyObject *vTextCanvasPane_cb_VScroll;
	PyObject *vTextCanvasPane_cb_ResizeText;
	PyObject *vTextCanvasPane_cb_Redraw;



    if (!PyArg_ParseTuple(args, "OOOOOOOOO",
			  &vTextCanvasPane_cb_TextMouseDown   ,
			  &vTextCanvasPane_cb_TextMouseUp     ,
			  &vTextCanvasPane_cb_TextMouseMove   ,
			  &vTextCanvasPane_cb_HPage           ,
			  &vTextCanvasPane_cb_VPage           ,
			  &vTextCanvasPane_cb_HScroll         ,
			  &vTextCanvasPane_cb_VScroll         ,
			  &vTextCanvasPane_cb_ResizeText      ,
			  &vTextCanvasPane_cb_Redraw
	))
	return NULL;

    	thisPane = new pytTextCanvasPane(vTextCanvasPane_cb_TextMouseDown   ,
					 vTextCanvasPane_cb_TextMouseUp     ,
					 vTextCanvasPane_cb_TextMouseMove   ,
					 vTextCanvasPane_cb_HPage  	    ,
					 vTextCanvasPane_cb_HScroll	    ,
					 vTextCanvasPane_cb_VPage  	    ,
					 vTextCanvasPane_cb_VScroll         ,
					 vTextCanvasPane_cb_ResizeText      ,
					 vTextCanvasPane_cb_Redraw
					 );
    return Py_BuildValue("l", thisPane);
}




PyObject * 
Py_vTextCanvasPane_ShowHScroll(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    int OnOff;
    if (!PyArg_Parse(args, "(li)", &thisPane, &OnOff))
	return NULL;
    thisPane->ShowHScroll(OnOff);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vTextCanvasPane_ShowVScroll(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    int OnOff;
    if (!PyArg_Parse(args, "(li)", &thisPane, &OnOff))
	return NULL;
    thisPane->ShowVScroll(OnOff);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vTextCanvasPane_Clear(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    int row, col;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    thisPane->Clear();
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vTextCanvasPane_ClearRow(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    int row, col;
    if (!PyArg_Parse(args, "(lii)", &thisPane, &row, &col))
	return NULL;
    thisPane->ClearRow(row, col);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vTextCanvasPane_ClearToEnd(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    int row, col;
    if (!PyArg_Parse(args, "(lii)", &thisPane, &row, &col))
	return NULL;
     thisPane->ClearToEnd(row, col);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vTextCanvasPane_GetCols(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    return Py_BuildValue("i", thisPane->GetCols());
}

PyObject * 
Py_vTextCanvasPane_GetRows(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    return Py_BuildValue("i", thisPane->GetRows());
}

PyObject * 
Py_vTextCanvasPane_GetRC(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    int row, col;

    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    thisPane->GetRC(row, col);
    return Py_BuildValue("(ii)", row, col);
}

PyObject * 
Py_vTextCanvasPane_GotoRC(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    int row, col;

    if (!PyArg_Parse(args, "(lii)", &thisPane, &row, &col))
	return NULL;
    thisPane->GotoRC(row, col);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vTextCanvasPane_DrawAttrText(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    char *pStr;
    int attr;
    if (!PyArg_Parse(args, "(lsi)", &thisPane, &pStr, &attr))
	return NULL;

    thisPane->DrawAttrText(pStr, (ChrAttr) attr);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vTextCanvasPane_DrawChar(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    PyObject *objTxt;
    char Char;
    int attr;
    if (!PyArg_Parse(args, "(lci)", &thisPane, &Char, &attr))
	return NULL;

    thisPane->DrawChar(Char, (ChrAttr) attr);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vTextCanvasPane_DrawText(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    char *pStr;

    if (!PyArg_Parse(args, "(ls)", &thisPane, &pStr))
	return NULL;

    thisPane->DrawText(pStr);

    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vTextCanvasPane_HideTextCursor(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    thisPane->HideTextCursor();
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vTextCanvasPane_ShowTextCursor(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    thisPane->ShowTextCursor();
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vTextCanvasPane_ScrollText(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    int cnt;
    if (!PyArg_Parse(args, "(li)", &thisPane, &cnt))
	return NULL;
    thisPane->ScrollText(cnt);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vTextCanvasPane_ResizeText(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    int rows, cols;
    if (!PyArg_Parse(args, "(lii)", &thisPane, &rows, &cols))
	return NULL;
    thisPane->ResizeText(rows, cols);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vTextCanvasPane_TextMouseDown(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    int row, col, button;
    if (!PyArg_Parse(args, "(liii)", &thisPane, &row, &col, &button))
	return NULL;
    thisPane->TextMouseDown(row, col, button);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vTextCanvasPane_TextMouseUp(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    int row, col, button;
    if (!PyArg_Parse(args, "(liii)", &thisPane, &row, &col, &button))
	return NULL;
    thisPane->TextMouseUp(row, col, button);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vTextCanvasPane_TextMouseMove(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    int row, col, button;
    if (!PyArg_Parse(args, "(liii)", &thisPane, &row, &col, &button))
	return NULL;
    thisPane->TextMouseMove(row, col, button);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vTextCanvasPane_Redraw(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    int x, y, height, width;
    if (!PyArg_Parse(args, "(liiii)", &thisPane, &x, &y, &width, &height ))
	return NULL;
    thisPane->Redraw(x, y, width, height);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vTextCanvasPane_SetHScroll(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    int Shown, Top;
    if (!PyArg_Parse(args, "(lii)", &thisPane, &Shown, &Top))
	return NULL;
    thisPane->SetHScroll(Shown, Top);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vTextCanvasPane_SetVScroll(PyObject* self, PyObject* args)
{
    pytTextCanvasPane* thisPane;
    int Shown, Top;
    if (!PyArg_Parse(args, "(lii)", &thisPane, &Shown, &Top))
	return NULL;
    thisPane->SetVScroll(Shown, Top);
    Py_INCREF (Py_None);
    return Py_None;
}
