//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvutls.cc 
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================



#include "pyvcnvs.h"


//======================================================================
pytCanvasPane::pytCanvasPane(PyObject *cb_FontChanged,
			     PyObject *cb_HPage,
			     PyObject *cb_VPage,  
			     PyObject *cb_HScroll,
			     PyObject *cb_VScroll,
			     PyObject *cb_MouseDown,
			     PyObject *cb_MouseUp,
			     PyObject *cb_MouseMove,
			     PyObject *cb_MouseMotion,
			     PyObject *cb_EnterFocus,
			     PyObject *cb_LeaveFocus,
			     PyObject *cb_Redraw,
			     PyObject *cb_Resize
			     ):vCanvasPane()
{
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_FontChanged, vCanvasPane_cb_FontChanged  );
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_HPage,       vCanvasPane_cb_HPage        );
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_VPage,       vCanvasPane_cb_VPage        );     
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_HScroll,     vCanvasPane_cb_HScroll      );   
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_VScroll,     vCanvasPane_cb_VScroll      );   
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_MouseDown,   vCanvasPane_cb_MouseDown    ); 
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_MouseUp,     vCanvasPane_cb_MouseUp      );   
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_MouseMove,   vCanvasPane_cb_MouseMove    ); 
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_MouseMotion, vCanvasPane_cb_MouseMotion  );
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_EnterFocus,  vCanvasPane_cb_EnterFocus   );
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_LeaveFocus,  vCanvasPane_cb_LeaveFocus   );
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_Redraw,      vCanvasPane_cb_Redraw       );    
    ASSIGN_PTR_OF_OBJECT_OR_NULL(cb_Resize,      vCanvasPane_cb_Resize       );    
    
    
    Py_XINCREF( vCanvasPane_cb_FontChanged    );
    Py_XINCREF( vCanvasPane_cb_HPage          );
    Py_XINCREF( vCanvasPane_cb_VPage          );
    Py_XINCREF( vCanvasPane_cb_HScroll        );
    Py_XINCREF( vCanvasPane_cb_VScroll        );
    Py_XINCREF( vCanvasPane_cb_MouseDown      );
    Py_XINCREF( vCanvasPane_cb_MouseUp        );
    Py_XINCREF( vCanvasPane_cb_MouseMove      );
    Py_XINCREF( vCanvasPane_cb_MouseMotion    );
    Py_XINCREF( vCanvasPane_cb_EnterFocus     );
    Py_XINCREF( vCanvasPane_cb_LeaveFocus     );
    Py_XINCREF( vCanvasPane_cb_Redraw         );
    Py_XINCREF( vCanvasPane_cb_Resize         );

}

//======================================================================
pytCanvasPane::~pytCanvasPane()
{
    Py_XDECREF( vCanvasPane_cb_FontChanged    );
    Py_XDECREF( vCanvasPane_cb_HPage          );
    Py_XDECREF( vCanvasPane_cb_VPage          );
    Py_XDECREF( vCanvasPane_cb_HScroll        );
    Py_XDECREF( vCanvasPane_cb_VScroll        );
    Py_XDECREF( vCanvasPane_cb_MouseDown      );
    Py_XDECREF( vCanvasPane_cb_MouseUp        );
    Py_XDECREF( vCanvasPane_cb_MouseMove      );
    Py_XDECREF( vCanvasPane_cb_MouseMotion    );
    Py_XDECREF( vCanvasPane_cb_EnterFocus     );
    Py_XDECREF( vCanvasPane_cb_LeaveFocus     );
    Py_XDECREF( vCanvasPane_cb_Redraw         );
    Py_XDECREF( vCanvasPane_cb_Resize         );
    
}



//======================================================================
//======================================================================
//======================================================================
void pytCanvasPane::FontChanged(vFont& vf)
{
  PyObject *arglist,*result;
  vFont *pFont;
  pFont=&vf;
  if(vCanvasPane_cb_FontChanged  != NULL)
  {
     arglist = Py_BuildValue("(l)", (PyObject *) pFont);
     result  = PyEval_CallObject(vCanvasPane_cb_FontChanged, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}

//======================================================================
void pytCanvasPane::HPage(int Shown, int Top)
{
 PyObject *arglist,*result;
  if(vCanvasPane_cb_HPage!= NULL)
  {
     arglist = Py_BuildValue("(ii)", Shown, Top);
     result  = PyEval_CallObject(vCanvasPane_cb_HPage, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}

//======================================================================
void pytCanvasPane::VPage(int Shown, int Top)
{
 PyObject *arglist,*result;
  if(vCanvasPane_cb_VPage!= NULL)
  {
     arglist = Py_BuildValue("(ii)", Shown, Top);
     result  = PyEval_CallObject(vCanvasPane_cb_VPage, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}

//======================================================================
void pytCanvasPane::HScroll(int step)
{
 PyObject *arglist,*result;
  if(vCanvasPane_cb_HScroll!= NULL)
  {
     arglist = Py_BuildValue("(i)", step);
     result  = PyEval_CallObject(vCanvasPane_cb_HScroll, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}

//======================================================================
void pytCanvasPane::VScroll(int step)
{
 PyObject *arglist,*result;
  if(vCanvasPane_cb_VScroll!= NULL)
  {
     arglist = Py_BuildValue("(i)", step);
     result  = PyEval_CallObject(vCanvasPane_cb_VScroll, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}
//======================================================================
void pytCanvasPane::MouseDown(int row, int col, int button)
{
  PyObject *arglist,*result;
  if(vCanvasPane_cb_MouseDown != NULL)
  {
     arglist = Py_BuildValue("(iii)", row, col, button);
     result  = PyEval_CallObject(vCanvasPane_cb_MouseDown, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}
//======================================================================
void pytCanvasPane::MouseUp(int row, int col, int button)
{
  PyObject *arglist,*result;
  if(vCanvasPane_cb_MouseUp != NULL)
  {
     arglist = Py_BuildValue("(iii)", row, col, button);
     result  = PyEval_CallObject(vCanvasPane_cb_MouseUp, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}
//======================================================================
void pytCanvasPane::MouseMove(int row, int col, int button)
{
  PyObject *arglist,*result;
  if(vCanvasPane_cb_MouseMove != NULL)
  {
     arglist = Py_BuildValue("(iii)", row, col, button);
     result  = PyEval_CallObject(vCanvasPane_cb_MouseMove, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}
//======================================================================
void pytCanvasPane::MouseMotion(int row, int col)
{
  PyObject *arglist,*result;
  if(vCanvasPane_cb_MouseMotion != NULL)
  {
     arglist = Py_BuildValue("(ii)", row, col);
     result  = PyEval_CallObject(vCanvasPane_cb_MouseMotion, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}

//======================================================================
void pytCanvasPane::EnterFocus()
{
  PyObject *result;
  if(vCanvasPane_cb_EnterFocus != NULL)
  {
     result  = PyEval_CallObject(vCanvasPane_cb_EnterFocus, (PyObject *) NULL);
     CHECK_RETURN_RESULT ( result );
  }
  vCanvasPane::EnterFocus();
}

//======================================================================
void pytCanvasPane::LeaveFocus()
{
  PyObject *result;
  if(vCanvasPane_cb_LeaveFocus != NULL)
  {
     result  = PyEval_CallObject(vCanvasPane_cb_LeaveFocus, (PyObject *) NULL);
     CHECK_RETURN_RESULT ( result );
  }
}


//======================================================================
void pytCanvasPane::Redraw(int x, int y,  int width, int height)
{
  PyObject *arglist,*result;
  if(vCanvasPane_cb_Redraw != NULL)
  {
     arglist = Py_BuildValue("(iiii)", x, y, width, height );
     result  = PyEval_CallObject(vCanvasPane_cb_Redraw, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}

//======================================================================
void pytCanvasPane::Resize(int newW, int newH)
{
  PyObject *arglist,*result;
  if(vCanvasPane_cb_Resize != NULL)
  {
     arglist = Py_BuildValue("(ii)", newW, newH);
     result  = PyEval_CallObject(vCanvasPane_cb_Resize, arglist);
     CHECK_RETURN_RESULT ( result );
     Py_DECREF(arglist);
  }
}


//======================================================================
//======================================================================
//======================================================================


PyObject * 
Py_vCanvasPane_Constructor(PyObject* self, PyObject* args)
{
    pytCanvasPane* thisPane;

    PyObject *cb_FontChanged;
    PyObject *cb_HPage;
    PyObject *cb_VPage;
    PyObject *cb_HScroll;
    PyObject *cb_VScroll;
    PyObject *cb_MouseDown;
    PyObject *cb_MouseUp;
    PyObject *cb_MouseMove;
    PyObject *cb_MouseMotion;
    PyObject *cb_EnterFocus;
    PyObject *cb_LeaveFocus;
    PyObject *cb_Redraw;
    PyObject *cb_Resize;     

//  Helps to count "O"           1234567890123
    if (!PyArg_ParseTuple(args, "OOOOOOOOOOOOO",
	&cb_FontChanged ,
	&cb_HPage       ,
	&cb_VPage       ,
	&cb_HScroll     ,
	&cb_VScroll     ,
	&cb_MouseDown   ,
	&cb_MouseUp     ,
	&cb_MouseMove   ,
	&cb_MouseMotion ,
	&cb_EnterFocus  ,
	&cb_LeaveFocus  ,
	&cb_Redraw      ,
	&cb_Resize
	))
	return NULL;

    thisPane = new pytCanvasPane(cb_FontChanged ,
				 cb_HPage       ,
				 cb_VPage       ,
				 cb_HScroll     ,
				 cb_VScroll     ,
				 cb_MouseDown   ,
				 cb_MouseUp     ,
				 cb_MouseMove   ,
				 cb_MouseMotion ,
				 cb_EnterFocus  ,
				 cb_LeaveFocus  ,
				 cb_Redraw      ,
				 cb_Resize
				 );
    return Py_BuildValue("l", thisPane);
}

PyObject * 
Py_vCanvasPane_ShowPane(PyObject* self, PyObject* args)
{
    pytCanvasPane* thisPane;
    int OnOrOff;
    if (!PyArg_Parse(args, "(li)", &thisPane, &OnOrOff))
	return NULL;
    thisPane->ShowPane(OnOrOff);
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vCanvasPane_SetWidthHeight(PyObject* self, PyObject* args)
{
    pytCanvasPane* thisPane;
    int height, width;
    if (!PyArg_Parse(args, "(lii)", &thisPane, &width, &height))
	return NULL;
    thisPane->SetWidthHeight(width, height);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vCanvasPane_SetCursor(PyObject* self, PyObject* args)
{
    pytCanvasPane* thisPane;
    int id;
    if (!PyArg_Parse(args, "(li)", &thisPane, &id))
	return NULL;
    thisPane->SetCursor(id);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vCanvasPane_GetCursor(PyObject* self, PyObject* args)
{
    pytCanvasPane* thisPane;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    return Py_BuildValue("i", thisPane->GetCursor());
}


PyObject * 
Py_vCanvasPane_UnSetCursor(PyObject* self, PyObject* args)
{
    pytCanvasPane* thisPane;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    thisPane->UnSetCursor();
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vCanvasPane_SetHScroll(PyObject* self, PyObject* args)
{
    pytCanvasPane* thisPane;
    int Shown, Top;
    if (!PyArg_Parse(args, "(lii)", &thisPane,&Shown, &Top))
	return NULL;
    thisPane->SetHScroll(Shown, Top);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vCanvasPane_SetVScroll(PyObject* self, PyObject* args)
{
    pytCanvasPane* thisPane;
    int Shown, Top;
    if (!PyArg_Parse(args, "(lii)", &thisPane,&Shown, &Top))
	return NULL;
    thisPane->SetVScroll(Shown, Top);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vCanvasPane_GetHScroll(PyObject* self, PyObject* args)
{
    pytCanvasPane* thisPane;
    int Shown, Top;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    thisPane->GetHScroll(Shown, Top);
    return Py_BuildValue("(ii)", Shown, Top);
}

PyObject * 
Py_vCanvasPane_GetVScroll(PyObject* self, PyObject* args)
{
    pytCanvasPane* thisPane;
    int Shown, Top;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    thisPane->GetVScroll(Shown, Top);
    return Py_BuildValue("(ii)", Shown, Top);
}



PyObject * 
Py_vCanvasPane_ShowHScroll(PyObject* self, PyObject* args)
{
    pytCanvasPane* thisPane;
    int OnOrOff;
    if (!PyArg_Parse(args, "(li)", &thisPane, &OnOrOff))
	return NULL;
    thisPane->ShowHScroll(OnOrOff);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vCanvasPane_ShowVScroll(PyObject* self, PyObject* args)
{
    pytCanvasPane* thisPane;
    int OnOrOff;
    if (!PyArg_Parse(args, "(li)", &thisPane, &OnOrOff))
	return NULL;
    thisPane->ShowVScroll(OnOrOff);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vCanvasPane_GetWidth(PyObject* self, PyObject* args)
{
    pytCanvasPane* thisPane;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    return Py_BuildValue("i", thisPane->GetWidth());
}


PyObject * 
Py_vCanvasPane_GetHeight(PyObject* self, PyObject* args)
{
    pytCanvasPane* thisPane;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    return Py_BuildValue("i", thisPane->GetHeight());
}

PyObject * 
Py_vCanvasPane_GetDC(PyObject* self, PyObject* args)
{
    pytCanvasPane* thisPane;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    return Py_BuildValue("l", thisPane->GetDC());
}



//
//
//
// ----------------------- DRAWING -----------------------
//
//
//

PyObject * 
Py_vDC_Clear(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    thisPane->Clear();
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_ClearRect(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int left, top, height, width;
    if (!PyArg_Parse(args, "(liiii)", &thisPane, &left, &top, &width, &height ))
	return NULL;
    thisPane->ClearRect(left, top, width, height);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_CopyFromMemoryDC(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    vMemoryDC* vmemdc;
    int destX, destY, srcX, srcY, srcW, srcH;
    if (!PyArg_Parse(args, "(lliiiiii)", 
			&thisPane, 
			&vmemdc, 
			&destX, 
			&destY,	
			&srcX, 
			&srcY, 
			&srcW, 
			&srcH
			))
	return NULL;
    thisPane->CopyFromMemoryDC(vmemdc, destX, destY, srcX, srcY, srcW, srcH);
    Py_INCREF (Py_None);
    return Py_None;
}

#ifdef DRAWARC   // This ifdef I found in vcanvas.h.   
//                 What is this ???
PyObject * 
Py_vDC_DrawArc(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int xx1, yy1, xx2, yy2, xxc, yyc;
    if (!PyArg_Parse(args, "(liiiiii)", &thisPane, &xx1, &yy1, &xx2, &yy2, &xxc, &yyc))
	return NULL;
    thisPane->DrawArc(xx1, yy1, xx2, yy2, xxc, yyc);
    Py_INCREF (Py_None);
    return Py_None;
}
#endif


PyObject * 
Py_vDC_DrawAttrText(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    char *pStr;
    int x, y, attr;
    if (!PyArg_Parse(args, "(liisi)", &thisPane, &x, &y, &pStr, &attr))
	return NULL;
    thisPane->DrawAttrText(x, y, pStr, (ChrAttr) attr);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_DrawText(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    char *pStr;
    int x, y;
    if (!PyArg_Parse(args, "(liis)", &thisPane, &x, &y, &pStr))
	return NULL;
    thisPane->DrawText(x, y, pStr);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_DrawEllipse(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int x, y, width, height;
    if (!PyArg_Parse(args, "(liiii)", &thisPane, &x, &y, &width, &height))
	return NULL;
    thisPane->DrawEllipse(x, y, width, height);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_DrawIcon(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    vIcon *pIcon;
    int x, y;
    if (!PyArg_Parse(args, "(liil)", &thisPane, &x, &y, &pIcon))
	return NULL;
    thisPane->DrawIcon(x, y, (vIcon&) *pIcon);
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vDC_DrawLine(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int x, y, xend, yend;
    if (!PyArg_Parse(args, "(liiii)", &thisPane, &x, &y, &xend, &yend))
	return NULL;
    thisPane->DrawLine(x, y, xend , yend);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_DrawLines(PyObject* self, PyObject* args)
{
    PyObject *objLine, *objTmp, *objType, *objList, *objStr;
    int szBytes, i, sizeOfList;
    vDC* thisPane;
    char *pBuf, *pStr;
    vLine *pLines;
    int count=0;

    int x, y, xend, yend;
    if (!PyArg_Parse(args, "(lO)", &thisPane, &objList))
	return NULL;

    sizeOfList=PyList_Size(objList);
    szBytes=sizeof(vLine)*(sizeOfList+1);
    pLines=(vLine *)malloc(szBytes);
    if(pLines == NULL)
	Py_v_FATAL_ERR("\nvPy_vDC_DrawLines: malloc error\n");
    
    for(i=0; i<sizeOfList; i++)
    {
	objLine=PyList_GetItem(objList,i);
	Py_INCREF(objLine);
	(pLines+i)->x    = (short) PyInt_AsLong (PyList_GetItem(objLine, 0)  );
	(pLines+i)->y    = (short) PyInt_AsLong (PyList_GetItem(objLine, 1)  );
	(pLines+i)->xend = (short) PyInt_AsLong (PyList_GetItem(objLine, 2)  );
	(pLines+i)->yend = (short) PyInt_AsLong (PyList_GetItem(objLine, 3)  );
	count++;
	Py_DECREF(objLine);
    }
    thisPane->DrawLines (pLines, count);
    free(pLines);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_DrawPoint(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int x, y;
    if (!PyArg_Parse(args, "(lii)", &thisPane, &x, &y))
	return NULL;
    thisPane->DrawPoint(x, y);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_DrawPoints(PyObject* self, PyObject* args)
{
    PyObject *objPoint, *objTmp, *objType, *objList, *objStr;
    int szBytes, i, sizeOfList;
    vDC* thisPane;
    vPoint *pPoints;
    int count=0;

    int x, y;
    if (!PyArg_Parse(args, "(lO)", &thisPane, &objList))
	return NULL;

    sizeOfList=PyList_Size(objList);
    szBytes=sizeof(vPoint)*(sizeOfList+1);
    pPoints=(vPoint *)malloc(szBytes);
    if(pPoints == NULL)
	Py_v_FATAL_ERR("\nvPy_vDC_DrawPoints: malloc error\n");
    
    for(i=0; i<sizeOfList; i++)
    {
	objPoint=PyList_GetItem(objList,i);
	Py_INCREF(objPoint);
	(pPoints+i)->x    = (short) PyInt_AsLong (PyList_GetItem(objPoint, 0)  );
	(pPoints+i)->y    = (short) PyInt_AsLong (PyList_GetItem(objPoint, 1)  );
	count++;
	Py_DECREF(objPoint);
    }
    thisPane->DrawPoints (pPoints, count);
    free(pPoints);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_DrawPolygon(PyObject* self, PyObject* args)
{
    PyObject *objPoint, *objTmp, *objType, *objList, *objStr;
    int szBytes, i, sizeOfList, fillMode;
    vDC* thisPane;
    vPoint *pPoints;
    int count=0;

    int x, y;
    if (!PyArg_Parse(args, "(lOi)", &thisPane, &objList, &fillMode))
	return NULL;

    sizeOfList=PyList_Size(objList);
    szBytes=sizeof(vPoint)*(sizeOfList+1);
    pPoints=(vPoint *)malloc(szBytes);
    if(pPoints == NULL)
	Py_v_FATAL_ERR("\nvPy_vDC_DrawPolygon: malloc error\n");
    
    for(i=0; i<sizeOfList; i++)
    {
	objPoint=PyList_GetItem(objList,i);
	Py_INCREF(objPoint);
	(pPoints+i)->x    = (short) PyInt_AsLong (PyList_GetItem(objPoint, 0)  );
	(pPoints+i)->y    = (short) PyInt_AsLong (PyList_GetItem(objPoint, 1)  );
	count++;
	Py_DECREF(objPoint);
    }
    thisPane->DrawPolygon(count, pPoints, fillMode);
    free(pPoints);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_DrawRoundedRectangle(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int x, y, width, height, radius;
    if (!PyArg_Parse(args, "(liiiii)", &thisPane, &x, &y, &width, &height, &radius))
	return NULL;
    thisPane->DrawRoundedRectangle(x, y, width, height, radius);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_DrawRectangle(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int x, y, width, height;
    if (!PyArg_Parse(args, "(liiii)", &thisPane, &x, &y, &width, &height))
	return NULL;
    thisPane->DrawRectangle(x, y, width, height);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_DrawRectangles(PyObject* self, PyObject* args)
{
    PyObject *objRect, *objTmp, *objType, *objList, *objStr;
    int szBytes, i, sizeOfList;
    vDC* thisPane;
    vRect *pRects;
    int count=0;
    int x, y, w, h;

    if (!PyArg_Parse(args, "(lO)", &thisPane, &objList))
	return NULL;

    sizeOfList=PyList_Size(objList);
    szBytes=sizeof(vRect)*(sizeOfList+1);
    pRects=(vRect *)malloc(szBytes);
    if(pRects == NULL)
	Py_v_FATAL_ERR("\nvPy_vDC_DrawRectangles: malloc error\n");
    
    for(i=0; i<sizeOfList; i++)
    {
	objRect=PyList_GetItem(objList,i);
	Py_INCREF(objRect);
	(pRects+i)->x    = (short) PyInt_AsLong (PyList_GetItem(objRect, 0)  );
	(pRects+i)->y    = (short) PyInt_AsLong (PyList_GetItem(objRect, 1)  );
	(pRects+i)->w    = (short) PyInt_AsLong (PyList_GetItem(objRect, 2)  );
	(pRects+i)->h    = (short) PyInt_AsLong (PyList_GetItem(objRect, 3)  );
	count++;
	Py_DECREF(objRect);
    }
    thisPane->DrawRectangles(pRects, count);
    free(pRects);
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vDC_DrawRubberLine(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int x, y, xend, yend;
    if (!PyArg_Parse(args, "(liiii)", &thisPane, &x, &y, &xend, &yend))
	return NULL;
    thisPane->DrawRubberLine(x, y, xend , yend);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_DrawRubberEllipse(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int x, y, width, height;
    if (!PyArg_Parse(args, "(liiii)", &thisPane, &x, &y, &width, &height))
	return NULL;
    thisPane->DrawRubberEllipse(x, y, width, height);
    Py_INCREF (Py_None);
    return Py_None;
}




PyObject * 
Py_vDC_DrawRubberPoint(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int x, y;
    if (!PyArg_Parse(args, "(lii)", &thisPane, &x, &y))
	return NULL;
    thisPane->DrawRubberPoint(x, y);
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vDC_DrawRubberRectangle(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int x, y, width, height;
    if (!PyArg_Parse(args, "(liiii)", &thisPane, &x, &y, &width, &height))
	return NULL;
    thisPane->DrawRubberRectangle(x, y, width, height);
    Py_INCREF (Py_None);
    return Py_None;
}



PyObject * 
Py_vDC_BeginPrinting(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    char* filename;
    int ask;
    int isColor, stat;

    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    stat=thisPane->BeginPrinting();
    return Py_BuildValue("i", stat);
}



PyObject * 
Py_vDC_EndPrinting(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    thisPane->EndPrinting();
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_BeginPage(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    thisPane->BeginPage();
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_EndPage(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    thisPane->EndPage();
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vDC_GetPhysHeight(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    char* filename;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    return Py_BuildValue("i", thisPane->GetPhysHeight());
}


PyObject * 
Py_vDC_GetPhysWidth(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    char* filename;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    return Py_BuildValue("i",thisPane->GetPhysWidth());
}


PyObject * 
Py_vDC_SetBackground(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    vColor* pColor;
    if (!PyArg_Parse(args, "(ll)", &thisPane, &pColor))
	return NULL;
    thisPane->SetBackground(*pColor);
    Py_INCREF (Py_None);
    return Py_None;
}

PyObject * 
Py_vDC_SetScale(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int mult, div;
    if (!PyArg_Parse(args, "(lii)", &thisPane, &mult, &div))
	return NULL;
    thisPane->SetScale(mult, div);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_GetScale(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int mult, div;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    thisPane->GetScale(mult, div);
    return Py_BuildValue("(ii)", mult, div);
}


PyObject * 
Py_vDC_SetTranslate(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int x, y;
    if (!PyArg_Parse(args, "(lii)", &thisPane, &x, &y))
	return NULL;
    thisPane->SetTranslate(x, y);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_SetTransX(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int x;
    if (!PyArg_Parse(args, "(li)", &thisPane, &x))
	return NULL;
    thisPane->SetTransX(x);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_SetTransY(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int y;
    if (!PyArg_Parse(args, "(li)", &thisPane, &y))
	return NULL;
    thisPane->SetTransY(y);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_GetTranslate(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int x, y;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    thisPane->GetTranslate(x, y);
    return Py_BuildValue("(ii)", x, y);
}


PyObject * 
Py_vDC_GetTransX(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    return Py_BuildValue("i", thisPane->GetTransX());
}


PyObject * 
Py_vDC_GetTransY(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    return Py_BuildValue("i", thisPane->GetTransY());
}


PyObject * 
Py_vDC_SetBrush(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    vBrush *pBrush;
    if (!PyArg_Parse(args, "(ll)", &thisPane, &pBrush))
	return NULL;
    thisPane->SetBrush(*pBrush);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_GetBrush(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    vBrush *pBrush;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    pBrush= new vBrush();
    *pBrush=thisPane->GetBrush();
    return Py_BuildValue("l", pBrush);
}


PyObject * 
Py_vDC_SetFont(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    vFont *pFont;
    if (!PyArg_Parse(args, "(ll)", &thisPane, &pFont))
	return NULL;
    thisPane->SetFont(*pFont);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_GetFont(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    vFont *pFont;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    pFont=new vFont();
    *pFont=thisPane->GetFont();
    return Py_BuildValue("l", pFont);
}



PyObject * 
Py_vDC_SetPen(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    vPen *pPen;
    if (!PyArg_Parse(args, "(ll)", &thisPane, &pPen))
	return NULL;
    thisPane->SetPen(*pPen);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_GetPen(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    vPen *pPen;
    if (!PyArg_Parse(args, "l", &thisPane))
	return NULL;
    pPen=new vPen();
    *pPen=thisPane->GetPen();
    return Py_BuildValue("l", pPen);
}




PyObject * 
Py_vDC_SetPrinter(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    vPrinter *pPrinter;
    if (!PyArg_Parse(args, "(ll)", &thisPane, &pPrinter))
	return NULL;
#ifdef comments_to_investigate
    thisPane->SetPrinter(*pPrinter);
#endif
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject * 
Py_vDC_TextHeight(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    int asc, des;
    if (!PyArg_Parse(args, "(lii)", &thisPane, &asc, &des))
	return NULL;
    return Py_BuildValue("l", thisPane->TextHeight(asc, des));
}

PyObject * 
Py_vDC_TextWidth(PyObject* self, PyObject* args)
{
    vDC* thisPane;
    char *pStr;
    if (!PyArg_Parse(args, "(ls)", &thisPane, &pStr))
	return NULL;
    return Py_BuildValue("l", thisPane->TextWidth(pStr));
}


