//========================================================================
//  
//     PYV -- Binding of Python and GUI V.
// 
//
//     File: pyvbrsh.cc
//
//     Author: 
//              Sofin Raskin, sofin@ecitele.com
//
//========================================================================

#include "pyvbrsh.h"


PyObject *
Py_vBrush_Constructor(PyObject* self, PyObject* args)
{
    vBrush *pBrush;
    unsigned int r, g, b;
    int style, fillMode;
    
    if (!PyArg_ParseTuple(args, "iiiii",
		     &r,
		     &g,
		     &b,
		     &style,
		     &fillMode
		     ))
	return NULL;

    pBrush = new vBrush(r, g, b, style, fillMode );

    return Py_BuildValue("l", (PyObject *) pBrush);
}
    
PyObject *
Py_vBrush_Destructor(PyObject* self, PyObject* args)
{
    vBrush *pBrush;
    if (!PyArg_Parse(args, "l",
		      &pBrush
		      ))
	return NULL;
    delete pBrush;
    Py_INCREF (Py_None);
    return Py_None;
}

  
  

PyObject *
Py_vBrush_GetColor(PyObject* self, PyObject* args)
{
    vBrush *pBrush;
    vColor *pColor;
    if (!PyArg_Parse(args, "l",
		     &pBrush
		     ))
	return NULL;
    pColor=new vColor();
    *pColor=pBrush->GetColor();
    return Py_BuildValue("l", (PyObject *) pColor);
}

PyObject *
Py_vBrush_GetFillMode(PyObject* self, PyObject* args)
{
    vBrush *pBrush;
    if (!PyArg_Parse(args, "l",
		     &pBrush
		     ))
	return NULL;
    return Py_BuildValue("l", (PyObject *) pBrush->GetFillMode());
}

PyObject *
Py_vBrush_GetStyle(PyObject* self, PyObject* args)
{
    vBrush *pBrush;
    if (!PyArg_Parse(args, "l",
		     &pBrush
		     ))
	return NULL;
    return Py_BuildValue("l", (PyObject *) pBrush->GetStyle());
}

PyObject *
Py_vBrush_SetColor(PyObject* self, PyObject* args)
{
    vBrush *pBrush;
    vColor *pColor;
    if (!PyArg_ParseTuple(args, "ll",
			  &pBrush,
			  &pColor
			  ))
	return NULL;
    pBrush->SetColor(*pColor);
    Py_INCREF (Py_None);
    return Py_None;
}
PyObject *
Py_vBrush_SetFillMode(PyObject* self, PyObject* args)
{
    vBrush *pBrush;
    int fillMode;
    if (!PyArg_ParseTuple(args, "li",
			  &pBrush,
			  &fillMode
			  ))
	return NULL;
    pBrush->SetFillMode(fillMode);
    Py_INCREF (Py_None);
    return Py_None;
}


PyObject *
Py_vBrush_SetStyle(PyObject* self, PyObject* args)
{
    vBrush *pBrush;
    int style;
    if (!PyArg_ParseTuple(args, "ll",
			  &pBrush,
			  &style
			  ))
	return NULL;
    pBrush->SetStyle(style);
    Py_INCREF (Py_None);
    return Py_None;
}









