#
#
#
#
from v import *
from V import *

import txtview

import sys
import os
import signal
import string
import marshal
import time


######################################
#
#       Default Settings.
#



_VDB_RC_FILENAME='vdb.rc'

_VDB_DOUBLE_CLICK_TIME =0.25

_VDB_w=400
_VDB_h=300
_VDB_name='VDB'


_VDB_lst_w=700
_VDB_lst_h=500
_VDB_lst_bg_color=vColor(10, 0, 200)
_VDB_lst_fg_color=ChWhite

_VDB_lst_sz_nuber = 4
_VDB_lst_space_after_nuber = '   '
#                             123
_VDB_lst_total_nuber_shift = 4+3


_VDB_color_of_PDB_out            =ChBlue
_VDB_color_of_kbd_chr            =ChRed
_VDB_color_current_line          =ChRed
_VDB_color_number_of_current_line=ChGreen
_VDB_color_number_of_BreakPoint  =ChYellow
_VDB_color_BreakPoint            =ChYellow
#
#
#
######################################

dlgVdb_Commands=[
[C_Frame,        400,    0,    "",          [],  CA_None,     isSens,     000,       0,     0,    0],
[C_Button,       401,    0,    " Help     ",[],  CA_None,     isSens,     400,       0,     0,    0],
[C_Button,       402,    0,    " Where    ",[],  CA_None,     isSens,     400,       0,     401,  0],
[C_Button,       403,    0,    " Down     ",[],  CA_None,     isSens,     400,       0,     402,  0],
[C_Button,       404,    0,    " Up       ",[],  CA_None,     isSens,     400,       0,     403,  0],
[C_Button,       405,    0,    " Break    ",[],  CA_None,     isSens,     400,       0,     404,  0],
[C_Button,       406,    0,    " CLear    ",[],  CA_None,     isSens,     400,       0,     405,  0],

[C_Button,       407,    0,    " Step     ",[],  CA_None,     isSens,     400,       401,   499,  0],
[C_Button,       410,    0,    " Next     ",[],  CA_None,     isSens,     400,       402,   407,  0],
[C_Button,       409,    0,    " Continue ",[],  CA_None,     isSens,     400,       403,   410,  0],
[C_Button,       408,    0,    " Return   ",[],  CA_None,     isSens,     400,       404,   409,  0],
[C_Button,       411,    0,    " Args     ",[],  CA_None,     isSens,     400,       405,   408,  0],
[C_Button,       412,    0,    " Print    ",[],  CA_None,     isSens,     400,       406,   411,  0],
[C_Label,        499,    0,    "      PDB commands", [],  CA_None, isSens,400,       0,     406,  0],

[C_Label,        100,    0,    "     ",     [],  CA_None,     isSens,       0,       400,     0,  0],

[C_Frame,        500,    0,    "",      [],  CA_None,     isSens,     000,       100,   0,    0],
[C_Button,       510,    0,    "Run   ",[],  CA_None,     isSens,     500,       0,     0,    0],
[C_Button,       520,    0,    "Abort ",[],  CA_None,     isSens,     500,       0,     510,  0],
[C_Button,       530,    0,    "Setup ",[],  CA_None,     isSens,     500,       0,     520,  0],
[C_Button,       540,    0,    "Exit  ",[],  CA_None,     isSens,     500,       0,     530,  0],

]



class Vdb_Commands:
	def __init__(self, win, Do, Run, Abort, Setup, Exit):
		self.dlg=vDialog(win, self.cb_Dialog)
		self.dlg.AddDialogCmds(dlgVdb_Commands)
		self.dlg.SetDialogTitle("Commands")
		self.left=-1
		self.top =0

		self.send_Do= Do
		self.Run    = Run
		self.Abort  = Abort
		self.Setup  = Setup
		self.Exit   = Exit

	def cb_Dialog(self, id, retval, ctype):
		if id==401:	self.Do('help'); return
		if id==402:	self.Do('where  '); return
		if id==403:	self.Do('down   '); return
		if id==404:	self.Do('up     '); return
		if id==405:	self.Do('break  '); return
		if id==406:	self.Do('clear  '); return
		if id==407:	self.Do('step   '); return
		if id==408:	self.Do('return '); return
		if id==409:	self.Do('continue'); return
		if id==410:	self.Do('next   '); return
		if id==411:	self.Do('args   '); return
		if id==412:	self.Do('print  '); return

		if id==510:	self.Run();         return
		if id==520:	self.Abort();       return
		if id==530:	self.Setup();       return
		if id==540:	self.Exit();        return


		
	def appear(self):
		if not self.dlg.IsDisplayed(): 
			self.dlg.ShowDialog()
			if self.left!=-1:
				self.dlg.SetDialogPosition(self.left, self.top)
		else:
			self.disappear()

	def disappear(self):
		if self.dlg.IsDisplayed(): 
			(self.left, self.top, w, h)=self.dlg.GetDialogPosition()
			self.dlg.CancelDialog()



	def Do(self,cmd):
		s=cmd+'\n'
		self.send_Do(s)

	def GetSetup(self):
		flgDisp=self.dlg.IsDisplayed()
		(self.left, self.top, w, h)=self.dlg.GetDialogPosition()
		return 	(flgDisp, self.left, self.top)
		
	def SetSetup(self, flgDisp, left, top):
		if flgDisp:
			self.left=left
			self.top=top
			self.appear()


		


class Vdb_Listing:
	def __init__(self, app, w, h, cb_MouseDown,Do):
		self.app=app
		self.Do=Do
		self.view=txtview.TxtView(w, h, 
					  'Source', 
					  [], 
					  colorBg=_VDB_lst_bg_color,
					  colorFg=_VDB_lst_fg_color,
					  filterFunc=self.filter,
					  cb_MouseDown=cb_MouseDown
					  )
		self.filename=''
		self.cur_row=-1
		old_cur_row=self.cur_row
		self.lstBreaks=[]
		self.Contexts={}

	def CheckForBreaks(self, row):
		if row in self.lstBreaks:
			self.lstBreaks.remove(row)
			self.Do('clear '+str(row+1)+'\n' )
		else:
			self.lstBreaks.append(row)
			self.Do('break '+str(row+1)+'\n' )

		self.view.RedrawLineNbr(row)
		return




	def appear(self):
		self.view.Raise()

	def filter(self, txt, row, line, color):

		s_nbr=string.zfill(str(row+1),_VDB_lst_sz_nuber)+_VDB_lst_space_after_nuber

		if self.cur_row==row+1:
			txt.DrawAttrText(s_nbr, _VDB_color_number_of_current_line)
			txt.DrawAttrText(line,  _VDB_color_current_line)
			return (0, '', 0)
			
		if row in self.lstBreaks:
			txt.DrawAttrText(s_nbr, _VDB_color_number_of_BreakPoint)
			txt.DrawAttrText(line,  _VDB_color_BreakPoint)
			return (0, '', 0)
			
		return (1, s_nbr+line, color)


	def show(self, filename, row):
		if filename!=self.filename:
			if self.filename!='':
				self.Contexts[self.filename]=[self.lines, self.lstBreaks]

			try:
				context=self.Contexts[filename]
			except:
				self.view.SetCursor(VC_Wait)
				self.view.SetTitle(filename)
				self.app.CheckEvents()
				fd=open(filename, 'r')
				lines=fd.read()
				fd.close()
				self.lines=string.split(lines,'\n')
				self.lstBreaks=[]
			else:
				self.lines=context[0]
				self.lstBreaks=context[1]


			
			self.filename=filename
			self.view.Init(self.lines)
			old_cur_row=self.cur_row=row
			self.view.DisplayLine(row)
			self.view.SetCursor(VC_IBar)

			
		else:
			old_cur_row=self.cur_row
			self.cur_row=row
			self.view.RedrawLineNbr(old_cur_row-1)
			self.view.RedrawLineNbr(self.cur_row-1)

	def GetSetup(self):
		win=self.view.GetWin()
		(left, top, width, height)=win.GetPosition()
		return (left, top)

	def SetSetup(self, left, top):
		win=self.view.GetWin()
		win.SetPosition(left, top)
		return

	
	def GetLineFromWin(self, row):
		(first,last)=self.view.GetFirstLastRows()
		buf_row=first+row
		if buf_row>=last: return ''
		else:
			return self.view.GetLine(buf_row)

	def Win2Buf(self, row):
		(first,last)=self.view.GetFirstLastRows()
		buf_row=first+row
		if buf_row>=last: return -1
		else:
			return buf_row

Vdb_CommandList=[
[C_Button,   1,    0,  "Commands",     [], CA_None,      isSens,  0, 0,  0, 0],
[C_Button,   2,    0,  "Listing",      [], CA_None,      isSens,  0, 1,  0, 0],
[C_Button,   3,    0,  "Setup",        [], CA_None,      isSens,  0, 2,  0, 0],
[C_Label,    4,    0,  " ",            [], CA_None,      isSens,  0, 3,  0, 0],
[C_Button,   415,  0,  "Exit",         [], CA_None,      isSens,  0, 4,  0, 0],
[C_Label,    6,    0,  "        ",     [], CA_None,      isSens,  0, 415,0, 0],
[C_Button,   5,    0,  "About",        [], CA_None,      isSens,  0, 6,  0, 0],
]


class Vdb:
	def __init__(self, app):

		self.app=app
		self.w    = _VDB_w
		self.h    = _VDB_h
		self.name = _VDB_name



		self.win  = vCmdWindow(self.name, self.w, self.h, cb_KeyIn=self.cb_KeyIn, cb_WindowCommand=self.cb_Window)
		self.cmd  = vCommandPane(Vdb_CommandList)
		self.txt  = vTextCanvasPane(cb_ResizeText=self.cb_ResizeText)
		self.win.AddPane(self.cmd)
		self.win.AddPane(self.txt)
		self.win.ShowWindow()

		self.pid=0

		self.vdb_cmds=Vdb_Commands(self.win, self.Do, self.Run, self.Abort, self.Setup, self.Exit)
		self.vdb_list=Vdb_Listing(self.app, _VDB_lst_w, _VDB_lst_h, self.cb_viewMouseDown, self.Do)

		self.ln=''
		self.dlgSetup =vModalDialog(self.win, self.cb_dlgSetup)
		self.dlgSetup.AddDialogCmds(dlg_Setup_cmds)

		cur_dir=os.listdir('./')

		if not self._Load_rc_file():
			self.Python_exec   = ''
			self.Python_script = ''
			self.Python_args   = ''
			self._flg_Save     = 1

		self.time_of_click_b1=0
		self.time_of_click_b2=0
		self.time_of_click_b3=0


		pdb_path=''
		for d in sys.path:
			files=os.listdir(d)
			for f in files:
				if f=='pdb.py':
					pdb_path=d+'/'+f
					break
			if len(pdb_path)>0: break
		self.Python_pdb = pdb_path		


	def cb_viewMouseDown(self, row, col, button):
		tm=time.time()

		if button==1:
			col = col-_VDB_lst_total_nuber_shift
			if col<0: 
				return
			if tm-self.time_of_click_b1<_VDB_DOUBLE_CLICK_TIME:
				self.Button1_double_click(row, col)
			else:
				self.time_of_click_b1=tm
			return

		if button==3:
			b_row=self.vdb_list.Win2Buf(row)
			self.vdb_list.CheckForBreaks(b_row)
			return
	






	def Button1_double_click(self,row, col):
		
		ln=self.vdb_list.GetLineFromWin(row)
		if len(ln)<=col: return

		p=col

		(p,ln)=self._StripWord(ln, p, ' ')
		(p,ln)=self._StripWord(ln, p, '=')
		(p,ln)=self._StripWord(ln, p, ',')
		(p,ln)=self._StripWord(ln, p, '(')
		(p,ln)=self._StripWord(ln, p, ')')
		(p,ln)=self._StripWord(ln, p, ',')
		(p,ln)=self._StripWord(ln, p, ';')
		(p,ln)=self._StripWord(ln, p, '+')
		(p,ln)=self._StripWord(ln, p, '-')
		(p,ln)=self._StripWord(ln, p, '*')
		(p,ln)=self._StripWord(ln, p, '/')
		(p,ln)=self._StripWord(ln, p, '[')
		(p,ln)=self._StripWord(ln, p, ']')
		(p,ln)=self._StripWord(ln, p, ',')
		(p,ln)=self._StripWord(ln, p, ':')
		(p,ln)=self._StripWord(ln, p, '\'')
		(p,ln)=self._StripWord(ln, p, '\"')

		if len(ln)==0: return

		self.Do('print '+ln+'\n')



	def _StripWord(self, ln, pos, separator):
		if pos==-1: return(-1,'')
		if ln[pos]==separator: return(-1,'')
		i=string.find(ln,separator, pos)
		if i!=-1:
			ln=ln[:i]
		i=string.rfind(ln, separator, 0)
###		print'          i, pos ',i,pos, ln[:i], ln[i:]
		if i!=-1:
			if  i< pos:
				ln=ln[i+1:]
			else:
				ln=ln[:i]
			pos=pos-i-1
		return (pos,ln)
		
		
	
	def Abort(self):
		if self.pid!=0:
			os.kill(self.pid, signal.SIGKILL)
			self.pid=0
		else:
			self.txt.DrawAttrText('Nothing to abort.\n',ChReverse)

		

	def Run(self):
		if self.pid!=0:
			self.txt.DrawAttrText('Appication is already running\n',ChReverse)
			return
		(self.pipe1_rx, self.pipe1_tx) = os.pipe()
		(self.pipe2_rx, self.pipe2_tx) = os.pipe()

		self.pid=os.fork()
		if self.pid==0:
			self.child_process()

		self.XtAdd_pipe2=pyv_UNX_XtAddInput(self.cb_pipe, fileno=self.pipe2_rx)
		
	def cb_pipe(self, fileno):
		line=os.read(self.pipe2_rx, 1)
		self.txt.DrawAttrText(line, _VDB_color_of_PDB_out)
		splt=string.split(line,'\n')
		if len(splt)==1:
			self.ln = self.ln + line
			return

		self.ln=self.ln+splt[0]
		self.ProcessOut(self.ln)
		self.ln=''

		return

	def ProcessOut(self, line):
		splt=string.split(line)
		sz=len(splt)
		if sz>2:
			if '>' not in splt: return
			idx=splt.index('>')
			if idx==sz-1: return
			ln=splt[idx+1]
			pos=string.find(ln,'()')
			if pos==-1: return
			self.ExtrctPos(ln[0:pos+2])

	def ExtrctPos(self, line):
		lp=string.find(line,'(')
		rp=string.find(line,')')
		filename=line[0:lp]
		row=string.atoi(line[lp+1:rp])
		self.ShowSrc(filename, row)
		
	def ShowSrc(self, filename, row):
		if filename=='<string>':
			return
		self.vdb_list.show(filename, row)


	def cb_KeyIn(self, key, shift):
		if key==vk_Return:
			self.Do('\n')
			self.ln=''
			return
		if key > 255: return
		s=chr(key)
		self.Do(s, _VDB_color_of_kbd_chr)



	def Do(self, s, colr=ChNormal):
		try:
			os.write(self.pipe1_tx, s)
		except:
			self.txt.DrawAttrText('First, run the application.\n', ChReverse)
		else:
			self.txt.DrawAttrText(s, colr)


		
	


	def child_process(self):
		os.dup2(self.pipe1_rx, 0)
		os.dup2(self.pipe2_tx, 1)
		os.dup2(self.pipe2_tx, 2)
		
		
		self.args=[self.Python_exec, '-u', '-i', self.Python_pdb, self.Python_script]
		args=string.split(self.Python_args)
		for i in args:
			self.args.append(i)

		os.execv(self.Python_exec, self.args)
		sys.exit()




	def cb_Window(self, id, retval, ctype):
		if id==1:	
			self.vdb_cmds.appear()
		if id==2:
			self.vdb_list.appear()
		if id==3:
			self.Setup()
		if id==415:
			self.Exit()
		if id==5:
			self.About()



	def About(self):
		vNoticeDialog(self.win,"\n\n\n\
          VDB -- frontend for PYTHON debugger pdb.               \n\
\n\
    Frontend is written on PYV = Python + GUI V.\n\n\
    Python:\n\
         Guido van Rossum,     guido@CNRI.Reston.VA.US\n\
    GUI V:\n\
         Bruce E. Wampler,          wampler@cs.unm.edu\n\
    PYV:\n\
         Sofin Raskin,               sofin@ecitele.com      \n\n\n")

	def Exit(self):
		if self.pid!=0:
			os.kill(self.pid, signal.SIGKILL)
		if self._flg_Save:  self._Save_rc_file()
		self.app.Exit()

	def _Save_rc_file(self):
		fd=open(_VDB_RC_FILENAME,'w')
		marshal.dump(self.Python_exec   , fd)
		marshal.dump(self.Python_script , fd)
		marshal.dump(self.Python_args   , fd)
		marshal.dump(self._flg_Save     , fd)

		# Pos of Listing window
		(left, top)=self.vdb_list.GetSetup()
		marshal.dump(left,                fd)
		marshal.dump(top,                 fd)

		# Pos of command window
		(left, top, w, h)=self.win.GetPosition()
		marshal.dump(left,                fd)
		marshal.dump(top,                 fd)

		# Pos of command dialog
		(flg, left, top)=self.vdb_cmds.GetSetup()
		marshal.dump(flg,                fd)
		marshal.dump(left,               fd)
		marshal.dump(top,                fd)

		fd.close()

	def _Load_rc_file(self):
		lstCurDir=os.listdir('./')
		if not _VDB_RC_FILENAME in lstCurDir:  return 0
		fd=open(_VDB_RC_FILENAME,'r')
		self.Python_exec   =marshal.load(fd)
		self.Python_script =marshal.load(fd)
		self.Python_args   =marshal.load(fd)
		self._flg_Save     =marshal.load(fd)

		# Pos of Listing window
		left=marshal.load(fd)
		top=marshal.load(fd)
		self.vdb_list.SetSetup(left, top)

		# Pos of command window
		left =marshal.load(fd)
		top  =marshal.load(fd)
		self.win.SetPosition(left, top)
		flg  =marshal.load(fd)
		left =marshal.load(fd)
		top  =marshal.load(fd)
		self.vdb_cmds.SetSetup(flg, left, top)
		fd.close()
		return 1

	def cb_ResizeText(self, rows, cols):
		self.txt.Clear()
		return 



	def Setup(self):
		self.dlgSetup.SetString(1020, self.Python_exec)
		self.dlgSetup.SetString(1026, self.Python_pdb)
		self.dlgSetup.SetString(1040, self.Python_script)
		self.dlgSetup.SetString(1060, self.Python_args)
		self.dlgSetup.SetValue (1100, self._flg_Save, Value)

		self.dlgSetup.ShowModalDialog()

	def cb_dlgSetup(self, cmdId, Val, CmdType):
		if cmdId==M_Cancel: self.dlgSetup.CancelDialog(); return
		if cmdId==M_Done: 
			self.Python_exec   =self.dlgSetup.GetTextIn(1020)
			self.Python_pdb    =self.dlgSetup.GetTextIn(1026)
			self.Python_script =self.dlgSetup.GetTextIn(1040)
			self.Python_args   =self.dlgSetup.GetTextIn(1060)
			self._flg_Save     =self.dlgSetup.GetValue(1100)
			self.dlgSetup.CloseDialog() 
			return





dlg_Setup_cmds=[
[C_Frame,        1000,     0,   "",                 [],  CA_None,     isSens,     0,       0,     0,    0],
[C_Label ,       1010,    0,    "Python exec  : ",  [],  CA_None,     isSens,     1000,    0,     0,    0],
[C_TextIn,       1020,    0,    "",                 [],  CA_None,     isSens,     1000,    1010,  0,   35],
[C_Label ,       1023,    0,    "File pdb.py  : ",  [],  CA_None,     isSens,     1000,    0,     1010, 0],
[C_TextIn,       1026,    0,    "",                 [],  CA_None,     isSens,     1000,    1023,  1010,35],
[C_Label,        1030,    0,    "Python file :  ",  [],  CA_None,     isSens,     1000,    0,     1023, 0],
[C_TextIn,       1040,    0,    "",                 [],  CA_None,     isSens,     1000,    1030,  1023,35],
[C_Label,        1050,    0,    "Args : ",          [],  CA_None,     isSens,     1000,    0,     1030, 0],
[C_TextIn,       1060,    0,    "",                 [],  CA_None,     isSens,     1000,    1050,  1030,43],

[C_CheckBox,     1100,    0,    "Save Changes",     [],  CA_None,     isSens,     0,       0,     1000, 0],

[C_Label ,       1250,    0,    "          ",       [],  CA_None,     isSens,     0,       0,     1100,  0],
[C_Button,       M_Cancel,0,    "Cancel",           [],  CA_None,     isSens,     0,       1250,  1100,  0],
[C_Label ,       1260,    0,    "               ",  [],  CA_None,     isSens,     0,       M_Cancel,1100,0],
[C_Button,       M_Done,  0,    "Close",            [],  CA_None,     isSens,     0,       1260,  1100,  0],
]






app  = vApp()
vdb  =Vdb(app)

# If you want the debug Info uncomment the following line
# dbg=vDebugDialog(app); dbg.SetDebug()

app.doEventLoop()



