from v import *
from V import *

import regsub
import string

#
#   Class TxtView.
#
#    Public methods:
#               Raise()    - raise window.
#               RedrawRow( row )  
#               GetLine(Number)
#               ChangeLine(Number, Line)
#               AppendLine(Line)
#               DisplayLine()
#               SetCursor()
#               SetTitle()
#               Init()
#               GetWin()
#               GetTxtCnvs()
#


_TxtView_CommandList=[
[C_Button,       1,    0,  "Top   ",  [], CA_None,  isSens,  0, 0,  0, 0],
[C_Button,       2,    0,  "Bottom",  [], CA_None,  isSens,  0, 1,  0, 0],
[C_Button,       3,    0,  "  <<  ",  [], CA_None,  isSens,  0, 2,  0, 0],
[C_Button,       4,    0,  "  >>  ",  [], CA_None,  isSens,  0, 3,  0, 0],
]

class TxtView:

	def __init__(self,  
		     w, h, 
		     name, 
		     lstLines, 
		     colorFg=ChNormal,
		     colorBg=None,
		     filterFunc=None,
		     commandList=None,
		     cb_cmdWin=None,
		     cb_MouseDown=None,
		     cb_MouseUp=None,
		     cb_MouseMove=None
		     ):

		self.colorFg=colorFg
		self.colorBg=colorBg
		self.filterFunc=filterFunc
		self.cb_cmdWin=cb_cmdWin

		self.win  = vCmdWindow(name, 
				       w, 
				       h, 
				       cb_KeyIn=self.cb_KeyIn, 
				       cb_WindowCommand=self.cb_Window)

		self.txt  = vTextCanvasPane(cb_ResizeText=self.cb_ResizeText,
					    cb_VPage=self.cb_VPage,
					    cb_VScroll=self.cb_VScroll,
					    cb_MouseDown=cb_MouseDown,
					    cb_MouseUp=cb_MouseUp,
					    cb_MouseMove=cb_MouseMove
					    )

		if commandList!=None:
			self.cmd  = vCommandPane(commandList)
		else:
			self.cmd  = vCommandPane(_TxtView_CommandList)

		self.win.AddPane(self.cmd)

		self.win.AddPane(self.txt)
		self.win.ShowWindow()
		self.Init(lstLines)

	def GetWin(self):
		return self.win

	def GetTxtCnvs(self):
		return self.txt

	def GetFirstLastRows(self):
		return (self.firstRow, self.lastRow)


	def Init(self,  lstLines):
		self.firstRow=0



		self.tab='      '  # Defines <TAB> substitutor

		self.mx_sz_ln=0
		self.lstLines=[]

		for ln in lstLines:
			ln=regsub.gsub('\t',self.tab,ln)
			self.lstLines.append(ln)
			sz=len(ln)
			if self.mx_sz_ln<sz: 
				self.mx_sz_ln=sz
		self.szLines=len(self.lstLines)

		return


	def SetCursor(self, cursor):
		self.txt.SetCursor(cursor)

	def SetTitle(self, title):
		self.win.SetTitle(title)

	def EnableNumbering(self, flg, w=4, color=ChBlue, Space='   '):
		self.flgNbr=flg
		self.NbrWidth=w
		self.NbrColr=color
		self.NbrSpace=Space
		return

	def GetLine(self, nbr):
		if self.szLines>nbr:
			return self.lstLines[nbr]
		else:
			return None

	def ChangeLine(self, nbr, Line):
		if self.szLines>nbr:
			ln=regsub.gsub('\t',self.tab,Line)
			self.lstLines[nbr]=ln


	def AppendLine(self, Line):
		self.lstLines,append(Line)

	def DisplayLine(self, nbr):
		self.firstRow=nbr-self.w_rows/2
		if self.firstRow<0: 
			self.firstRow=0
		if self.firstRow>=self.szLines: self.firstRow=self.szLines-1
		self._redraw_buffer()
		return



	def RedrawLineNbr(self, b_row):
		if b_row > self.firstRow and b_row < self.lastRow:
			self._redraw_line(self.lstLines[b_row], b_row-self.firstRow, b_row)
		else:
			self.DisplayLine(b_row)

			

	def Raise(self):
		self.win.RaiseWindow()



	def cb_Window(self, id, retval, ctype):
		if id==1:	
			self.Do_Top();       return
		if id==2:
			self.Do_Bottom();    return
		if id==3:
			self.Do_Up();        return
		if id==4:
			self.Do_Down();      return

		if self.cb_cmdWin!=None:
			self.cb_cmdWin(id, retval, ctype)



	def Do_Top(self):
		self.DisplayLine(0)

	def Do_Bottom(self):
		self.DisplayLine(self.szLines)

	def Do_Up(self):
		self.cb_KeyIn(vk_Page_Up,   0)

	def Do_Down(self):
		self.cb_KeyIn(vk_Page_Down, 0)




	def cb_KeyIn(self, key, shift):
		if key==vk_Down:
			self.firstRow=self.firstRow+1
			if self.firstRow==self.szLines: self.firstRow=self.szLines-1
			self._redraw_buffer()
			return
			
		if key==vk_Up:
			self.firstRow=self.firstRow-1
			if self.firstRow<0: self.firstRow=0
			self._redraw_buffer()
			return


		if key==vk_Page_Down:
			self.firstRow=self.firstRow+self.w_rows-1
			if self.firstRow>=self.szLines: self.firstRow=self.szLines-1
			self._redraw_buffer()
			return

		if key==vk_Page_Up:
			self.firstRow=self.firstRow-self.w_rows+1
			if self.firstRow<0: self.firstRow=0
			self._redraw_buffer()
			return
			

	def cb_ResizeText(self, rows, cols):
		if self.colorBg!=None:
			self.txt.SetBackground(self.colorBg)
		self.w_rows=rows
		self.w_cols=cols
		self._redraw_buffer()


	def _redraw_buffer(self):
		self.txt.Clear()
		self.txt.HideTextCursor()
		

		self.lastRow=self.firstRow+self.w_rows-1

		if self.lastRow>=self.szLines: 
			self.lastRow=self.szLines-1
			if self.szLines>self.w_rows:
				self.firstRow=self.lastRow-(self.w_rows-1)
			else:
				self.firstRow=0

		
		w_r=0
		b_r=self.firstRow

		for ln in self.lstLines[self.firstRow:self.lastRow+1]:


			self._redraw_line(ln, w_r, b_r)
			w_r=w_r+1
			b_r=b_r+1
	

		if self.firstRow>0 or self.lastRow<self.szLines-1:
			self.flgVScroll=1
		else:
			self.flgVScroll=0


		self.txt.ShowVScroll(self.flgVScroll)
		if self.flgVScroll:
			Shown= self.w_rows*100/self.szLines  # 0..100
			Top  = self.firstRow*100/(self.szLines-self.w_rows)
			self.txt.SetVScroll(Shown, Top)

		if self.cb_cmdWin==None:
			self.win.SetString(11, str(self.firstRow)+':'+str(self.lastRow))
			

	def _redraw_line(self, ln, w_r, b_r):
		self.txt.GotoRC(w_r,0)
		self.txt.HideTextCursor()
		if len(ln)>self.w_cols:
			ln=ln[0:self.w_cols]

		if self.filterFunc!=None:
			(rez, ln, color)=self.filterFunc(self.txt, 
							 b_r, 
							 ln, 
							 self.colorFg
							 )

			if rez: self.txt.DrawAttrText(ln,  color)
		else:
			self.txt.DrawAttrText(ln,    self.colorFg)
		self.txt.HideTextCursor()




	def cb_VPage(self, Shown, Top):
		self.firstRow=Top*(self.szLines-self.w_rows)/100
		self._redraw_buffer()

		
	def cb_VScroll(self, step):
		self.firstRow=self.firstRow+step*(self.szLines-self.w_rows)/100
		if self.firstRow<0: self.firstRow=0
		self._redraw_buffer()
		return




if __name__ == '__main__':
	import sys
	filename=sys.argv[-1]
	app  = vApp()
	fd=open(filename,'r')
	s=fd.read()
	buf=string.split(s,'\n')
	tv   = TxtView(300, 300, 'VIEWER', [])
	tv.Init(buf)
	app.doEventLoop()

