/*
      Copyright (C) 1996, Eccosys Co. Ltd. (Sen Nagata)
      For the portions of the software written by Sen Nagata
      (this excludes the included nkf.c and kconv.h),
      everyone is permitted to do anything on this program 
      including copying, modifying, improving as long as you don't 
      try to make money off it, or pretend that you wrote it.
      i.e., the above copyright notice has to appear in all copies.
      THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE.

      See the README file for more information about the origins of this
      software.

      See the INSTALL file for instructions on installation.

      Sen Nagata (sen@eccosys.com)

      updated 2/10/97 

      thanks to takeuchi@cyclone.isl.ntt.co.jp for comments and suggestions
      concerning allocating a buffer for use with do_kconv() and freeing
      the allocated memory 
   
*/

#include "Python.h"
/*
#include <string.h>
#include <strings.h>
*/
#include "kconv.h"

/* 
_AUTO	0
_JIS	1
_EUC	2
_SJIS	3
*/

/* note: below, i say 'convert a value to/from python from/to c', strictly
   speaking, everything is in c here, but you get the point */
static PyObject*
wrap_kconv(self, args)
     PyObject* self;
     PyObject* args;
{
  char* input_string;  /* string to convert */
  char* output_string; /* converted string */

  int out_code; /* input kanji code */
  int in_code;  /* output kanji code */
  int in_len;   /* length of data to convert in bytes */
  int out_len;  /* number of converted bytes */

  PyObject* out; /* value to return to python */

  /* 'convert' python arguments to c arguments */
  if (!PyArg_ParseTuple(args, "s|ii", &input_string, &out_code, &in_code)) {
    return NULL;
  }
  
  /* calculate a suitable buffer size for the converted string */
  in_len = strlen(input_string);
  in_len = (in_len * 3) + 10;

  /* allocate enough space for the results to be stored */
  output_string = (char*)malloc((size_t)in_len);

  /* call the c function do_kconv -- we store the resulting length,
     but for the moment, just throw it away */
  out_len = do_kconv(input_string, output_string, in_len, out_code, in_code);

  /* convert the relevant c value into a python value */
  out = Py_BuildValue("s", output_string);

  /* free the allocated memory */
  free((void *)output_string);

  /* return the value we wish to pass to python */
  return out;
}

static PyMethodDef KconvMethods[] = {
  {"convert", wrap_kconv, 1},
  {NULL, NULL}
};

void
initkconv()
{
  (void) Py_InitModule("kconv", KconvMethods);
}
