# oraclass.py - A basic set of wrapper classes for the Python Oracle module.
#
# Copyright 1995 Thomas J. Culliton
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.
# Thomas J. Culliton makes no representations about the suitability of
# this software for any purpose.  It is provided "as is" without express
# or implied warranty.  By use of this software the user agrees to
# indemnify and hold harmless Thomas J. Culliton from any  claims or
# liability for loss arising out of such use.

"""A basic set of wrapper classes for the Python Oracle module.

The __getattr__ in the Connection class also provides the read only
atributes code and valid.  The one in the Cursor class provides code,
valid, and rows.
"""
__version__	= "$Revision: 1.2 $"

import oracle

def GetMaxLong() :
	return oracle.maxlong(-1)

def SetMaxLong(limit) :
	return oracle.maxlong(limit)

class Connection :

	"""A simple wrapper for the oracle connection class
	It makes the interface a bit more object oriented too.
	"""

	def __init__(self, logon_string) :
		self.logon = logon_string
		self.con = oracle.logon(logon_string)

	def __getattr__(self, attribute_name) :
		return getattr(self.con, attribute_name)

	def logoff(self) :
		self.con.logoff()

	def commit(self) :
		self.con.commit()

	def rollback(self) :
		self.con.rollback()

	def autocommit(self, setting_string) :
		self.con.autocommit(setting_string)

class Cursor :

	"""A simple wrapper for the oracle cursor class.
	It makes the interface a bit more object oriented too.
	"""

	def __init__(self, connection_object) :
		self.con = connection_object
		self.cur = connection_object.con.opencursor()

	def __getattr__(self, attribute_name) :
		return getattr(self.cur, attribute_name)

	def execsql(self, sql, src_data = ()) :
		if src_data != () :
			self.cur.execsql(sql, src_data)
		else :
			self.cur.execsql(sql)

	def describe(self) :
		return self.cur.describe()

	def fetch(self) :
		return self.cur.fetch()

	def cancel(self) :
		self.cur.cancel()

	def close(self) :
		self.cur.close()
