#!/usr/local/bin/python

# dumptbls.py - A simple table dumper.
#
# Copyright 1994, 1995 Thomas J. Culliton
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  
# Thomas J. Culliton makes no representations about the suitability of
# this software for any purpose.  It is provided "as is" without express
# or implied warranty.  By use of this software the user agrees to 
# indemnify and hold harmless Thomas J. Culliton from any  claims or
# liability for loss arising out of such use.

__doc__ = "An example of using the Python oracle module, a simple table dumper"

__version__ = "$Revision: 1.7 $"

import oracle

dblogon = "nobody/nothing"
select = "select * from user_tables"
limit = 10000

oracle.maxlong(limit)			# ALWAYS SET A REASONABLE SIZE!

con = oracle.newconnection(dblogon)

con.autocommit("off")			# demo fluff, just to show it's use

cur = con.opencursor()

cur.execsql(select)

cols = cur.describe()

print "column name, type, dispsz, dbsize, prec, scale, nullok"
print "------------------------------------------------"
for col in cols :
	print col
print

while 1 :
	rec = cur.fetch()
	if rec == None :
		break
	for i in range(0, len(rec)) :
		print cols[i][0] + ":", rec[i]
	print

print "Number of rows:", cur.rows

cur.close()

con.rollback()				# demo fluff, just to show it's use

con.logoff()
