# desc.py - Print a readable version of the Oracle column descriptions.
#
# Copyright 1994, 1995 Thomas J. Culliton
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  
# Thomas J. Culliton makes no representations about the suitability of
# this software for any purpose.  It is provided "as is" without express
# or implied warranty.  By use of this software the user agrees to 
# indemnify and hold harmless Thomas J. Culliton from any  claims or
# liability for loss arising out of such use.

__doc__		= "Print a readable version of the Oracle column descriptions"

__version__	= "$Revision: 1.2 $"

def colrep(col) :
	rep = "%30s is " % col[0]
	if col[1] == 1 :
		rep = rep + "VARCHAR2(" + `col[3]` + ")"
	elif col[1] == 2 :
		rep = rep + "NUMBER"
		if col[4] != 0 or col[5] != 0 :
			rep = rep + "(" + `col[4]` + "." + `col[5]` + ")"
	elif col[1] == 8 :
		rep = rep + "LONG CHAR(" + `col[3]` + ")"
	elif col[1] == 11 :
		rep = rep + "ROWID"
	elif col[1] == 12 :
		rep = rep + "DATE"
	elif col[1] == 23 :
		rep = rep + "RAW(" + `col[3]` + ")"
	elif col[1] == 24 :
		rep = rep + "LONG RAW(" + `col[3]` + ")"
	elif col[1] == 96 :
		rep = rep + "CHAR(" + `col[3]` + ")"
	else :
		rep = rep + "<UNKOWN TYPE>"
	if col[6] == 1 :
		rep = rep + " and may be null"
	return rep

def pcols(cols) :
	for col in cols :
		print colrep(col)


